/* xpm_out.c: output of XPM maps */

#include <stdio.h>
#include <stdlib.h>

/* f_xpm is already opened, will be closed in calling routine
   this is the common part of various XPM outputs */
void WriteGrayScale(FILE *f_xpm, const char* string)
{
  fprintf(f_xpm, "/* colors */\n");
  fprintf(f_xpm, " \"  0 s 0.00%s c white  g4 white  g white  m white \",\n", string);
  fprintf(f_xpm, " \"  1 s 0.01%s c gray99 g4 gray99 g gray99 m gray99 \",\n", string);
  fprintf(f_xpm, " \"  2 s 0.02%s c gray98 g4 gray98 g gray98 m gray98 \",\n", string);
  fprintf(f_xpm, " \"  3 s 0.03%s c gray97 g4 gray97 g gray97 m gray97 \",\n", string);
  fprintf(f_xpm, " \"  4 s 0.04%s c gray96 g4 gray96 g gray96 m gray96 \",\n", string);
  fprintf(f_xpm, " \"  5 s 0.05%s c gray95 g4 gray95 g gray95 m gray95 \",\n", string);
  fprintf(f_xpm, " \"  6 s 0.06%s c gray94 g4 gray94 g gray94 m gray94 \",\n", string);
  fprintf(f_xpm, " \"  7 s 0.07%s c gray93 g4 gray93 g gray93 m gray93 \",\n", string);
  fprintf(f_xpm, " \"  8 s 0.08%s c gray92 g4 gray92 g gray92 m gray92 \",\n", string);
  fprintf(f_xpm, " \"  9 s 0.09%s c gray91 g4 gray91 g gray91 m gray91 \",\n", string);
  fprintf(f_xpm, " \" 10 s 0.10%s c gray90 g4 gray90 g gray90 m gray90 \",\n", string);
  fprintf(f_xpm, " \" 11 s 0.11%s c gray89 g4 gray89 g gray89 m gray89 \",\n", string);
  fprintf(f_xpm, " \" 12 s 0.12%s c gray88 g4 gray88 g gray88 m gray88 \",\n", string);
  fprintf(f_xpm, " \" 13 s 0.13%s c gray87 g4 gray87 g gray87 m gray87 \",\n", string);
  fprintf(f_xpm, " \" 14 s 0.14%s c gray86 g4 gray86 g gray86 m gray86 \",\n", string);
  fprintf(f_xpm, " \" 15 s 0.15%s c gray85 g4 gray85 g gray85 m gray85 \",\n", string);
  fprintf(f_xpm, " \" 16 s 0.16%s c gray84 g4 gray84 g gray84 m gray84 \",\n", string);
  fprintf(f_xpm, " \" 17 s 0.17%s c gray83 g4 gray83 g gray83 m gray83 \",\n", string);
  fprintf(f_xpm, " \" 18 s 0.18%s c gray82 g4 gray82 g gray82 m gray82 \",\n", string);
  fprintf(f_xpm, " \" 19 s 0.19%s c gray81 g4 gray81 g gray81 m gray81 \",\n", string);
  fprintf(f_xpm, " \" 20 s 0.20%s c gray80 g4 gray80 g gray80 m gray80 \",\n", string);
  fprintf(f_xpm, " \" 21 s 0.21%s c gray79 g4 gray79 g gray79 m gray79 \",\n", string);
  fprintf(f_xpm, " \" 22 s 0.22%s c gray78 g4 gray78 g gray78 m gray78 \",\n", string);
  fprintf(f_xpm, " \" 23 s 0.23%s c gray77 g4 gray77 g gray77 m gray77 \",\n", string);
  fprintf(f_xpm, " \" 24 s 0.24%s c gray76 g4 gray76 g gray76 m gray76 \",\n", string);
  fprintf(f_xpm, " \" 25 s 0.25%s c gray75 g4 gray75 g gray75 m gray75 \",\n", string);
  fprintf(f_xpm, " \" 26 s 0.26%s c gray74 g4 gray74 g gray74 m gray74 \",\n", string);
  fprintf(f_xpm, " \" 27 s 0.27%s c gray73 g4 gray73 g gray73 m gray73 \",\n", string);
  fprintf(f_xpm, " \" 28 s 0.28%s c gray72 g4 gray72 g gray72 m gray72 \",\n", string);
  fprintf(f_xpm, " \" 29 s 0.29%s c gray71 g4 gray71 g gray71 m gray71 \",\n", string);
  fprintf(f_xpm, " \" 30 s 0.30%s c gray70 g4 gray70 g gray70 m gray70 \",\n", string);
  fprintf(f_xpm, " \" 31 s 0.31%s c gray69 g4 gray69 g gray69 m gray69 \",\n", string);
  fprintf(f_xpm, " \" 32 s 0.32%s c gray68 g4 gray68 g gray68 m gray68 \",\n", string);
  fprintf(f_xpm, " \" 33 s 0.33%s c gray67 g4 gray67 g gray67 m gray67 \",\n", string);
  fprintf(f_xpm, " \" 34 s 0.34%s c gray66 g4 gray66 g gray66 m gray66 \",\n", string);
  fprintf(f_xpm, " \" 35 s 0.35%s c gray65 g4 gray65 g gray65 m gray65 \",\n", string);
  fprintf(f_xpm, " \" 36 s 0.36%s c gray64 g4 gray64 g gray64 m gray64 \",\n", string);
  fprintf(f_xpm, " \" 37 s 0.37%s c gray63 g4 gray63 g gray63 m gray63 \",\n", string);
  fprintf(f_xpm, " \" 38 s 0.38%s c gray62 g4 gray62 g gray62 m gray62 \",\n", string);
  fprintf(f_xpm, " \" 39 s 0.39%s c gray61 g4 gray61 g gray61 m gray61 \",\n", string);
  fprintf(f_xpm, " \" 40 s 0.40%s c gray60 g4 gray60 g gray60 m gray60 \",\n", string);
  fprintf(f_xpm, " \" 41 s 0.41%s c gray59 g4 gray59 g gray59 m gray59 \",\n", string);
  fprintf(f_xpm, " \" 42 s 0.42%s c gray58 g4 gray58 g gray58 m gray58 \",\n", string);
  fprintf(f_xpm, " \" 43 s 0.43%s c gray57 g4 gray57 g gray57 m gray57 \",\n", string);
  fprintf(f_xpm, " \" 44 s 0.44%s c gray56 g4 gray56 g gray56 m gray56 \",\n", string);
  fprintf(f_xpm, " \" 45 s 0.45%s c gray55 g4 gray55 g gray55 m gray55 \",\n", string);
  fprintf(f_xpm, " \" 46 s 0.46%s c gray54 g4 gray54 g gray54 m gray54 \",\n", string);
  fprintf(f_xpm, " \" 47 s 0.47%s c gray53 g4 gray53 g gray53 m gray53 \",\n", string);
  fprintf(f_xpm, " \" 48 s 0.48%s c gray52 g4 gray52 g gray52 m gray52 \",\n", string);
  fprintf(f_xpm, " \" 49 s 0.49%s c gray51 g4 gray51 g gray51 m gray51 \",\n", string);
  fprintf(f_xpm, " \" 50 s 0.50%s c gray50 g4 gray50 g gray50 m gray50 \",\n", string);
  fprintf(f_xpm, " \" 51 s 0.51%s c gray49 g4 gray49 g gray49 m gray49 \",\n", string);
  fprintf(f_xpm, " \" 52 s 0.52%s c gray48 g4 gray48 g gray48 m gray48 \",\n", string);
  fprintf(f_xpm, " \" 53 s 0.53%s c gray47 g4 gray47 g gray47 m gray47 \",\n", string);
  fprintf(f_xpm, " \" 54 s 0.54%s c gray46 g4 gray46 g gray46 m gray46 \",\n", string);
  fprintf(f_xpm, " \" 55 s 0.55%s c gray45 g4 gray45 g gray45 m gray45 \",\n", string);
  fprintf(f_xpm, " \" 56 s 0.56%s c gray44 g4 gray44 g gray44 m gray44 \",\n", string);
  fprintf(f_xpm, " \" 57 s 0.57%s c gray43 g4 gray43 g gray43 m gray43 \",\n", string);
  fprintf(f_xpm, " \" 58 s 0.58%s c gray42 g4 gray42 g gray42 m gray42 \",\n", string);
  fprintf(f_xpm, " \" 59 s 0.59%s c gray41 g4 gray41 g gray41 m gray41 \",\n", string);
  fprintf(f_xpm, " \" 60 s 0.60%s c gray40 g4 gray40 g gray40 m gray40 \",\n", string);
  fprintf(f_xpm, " \" 61 s 0.61%s c gray39 g4 gray39 g gray39 m gray39 \",\n", string);
  fprintf(f_xpm, " \" 62 s 0.62%s c gray38 g4 gray38 g gray38 m gray38 \",\n", string);
  fprintf(f_xpm, " \" 63 s 0.63%s c gray37 g4 gray37 g gray37 m gray37 \",\n", string);
  fprintf(f_xpm, " \" 64 s 0.64%s c gray36 g4 gray36 g gray36 m gray36 \",\n", string);
  fprintf(f_xpm, " \" 65 s 0.65%s c gray35 g4 gray35 g gray35 m gray35 \",\n", string);
  fprintf(f_xpm, " \" 66 s 0.66%s c gray34 g4 gray34 g gray34 m gray34 \",\n", string);
  fprintf(f_xpm, " \" 67 s 0.67%s c gray33 g4 gray33 g gray33 m gray33 \",\n", string);
  fprintf(f_xpm, " \" 68 s 0.68%s c gray32 g4 gray32 g gray32 m gray32 \",\n", string);
  fprintf(f_xpm, " \" 69 s 0.69%s c gray31 g4 gray31 g gray31 m gray31 \",\n", string);
  fprintf(f_xpm, " \" 70 s 0.70%s c gray30 g4 gray30 g gray30 m gray30 \",\n", string);
  fprintf(f_xpm, " \" 71 s 0.71%s c gray29 g4 gray29 g gray29 m gray29 \",\n", string);
  fprintf(f_xpm, " \" 72 s 0.72%s c gray28 g4 gray28 g gray28 m gray28 \",\n", string);
  fprintf(f_xpm, " \" 73 s 0.73%s c gray27 g4 gray27 g gray27 m gray27 \",\n", string);
  fprintf(f_xpm, " \" 74 s 0.74%s c gray26 g4 gray26 g gray26 m gray26 \",\n", string);
  fprintf(f_xpm, " \" 75 s 0.75%s c gray25 g4 gray25 g gray25 m gray25 \",\n", string);
  fprintf(f_xpm, " \" 76 s 0.76%s c gray24 g4 gray24 g gray24 m gray24 \",\n", string);
  fprintf(f_xpm, " \" 77 s 0.77%s c gray23 g4 gray23 g gray23 m gray23 \",\n", string);
  fprintf(f_xpm, " \" 78 s 0.78%s c gray22 g4 gray22 g gray22 m gray22 \",\n", string);
  fprintf(f_xpm, " \" 79 s 0.79%s c gray21 g4 gray21 g gray21 m gray21 \",\n", string);
  fprintf(f_xpm, " \" 80 s 0.80%s c gray20 g4 gray20 g gray20 m gray20 \",\n", string);
  fprintf(f_xpm, " \" 81 s 0.81%s c gray19 g4 gray19 g gray19 m gray19 \",\n", string);
  fprintf(f_xpm, " \" 82 s 0.82%s c gray18 g4 gray18 g gray18 m gray18 \",\n", string);
  fprintf(f_xpm, " \" 83 s 0.83%s c gray17 g4 gray17 g gray17 m gray17 \",\n", string);
  fprintf(f_xpm, " \" 84 s 0.84%s c gray16 g4 gray16 g gray16 m gray16 \",\n", string);
  fprintf(f_xpm, " \" 85 s 0.85%s c gray15 g4 gray15 g gray15 m gray15 \",\n", string);
  fprintf(f_xpm, " \" 86 s 0.86%s c gray14 g4 gray14 g gray14 m gray14 \",\n", string);
  fprintf(f_xpm, " \" 87 s 0.87%s c gray13 g4 gray13 g gray13 m gray13 \",\n", string);
  fprintf(f_xpm, " \" 88 s 0.88%s c gray12 g4 gray12 g gray12 m gray12 \",\n", string);
  fprintf(f_xpm, " \" 89 s 0.89%s c gray11 g4 gray11 g gray11 m gray11 \",\n", string);
  fprintf(f_xpm, " \" 90 s 0.90%s c gray10 g4 gray10 g gray10 m gray10 \",\n", string);
  fprintf(f_xpm, " \" 91 s 0.91%s c gray9 g4 gray9 g gray9 m gray9 \",\n", string);
  fprintf(f_xpm, " \" 92 s 0.92%s c gray8 g4 gray8 g gray8 m gray8 \",\n", string);
  fprintf(f_xpm, " \" 93 s 0.93%s c gray7 g4 gray7 g gray7 m gray7 \",\n", string);
  fprintf(f_xpm, " \" 94 s 0.94%s c gray6 g4 gray6 g gray6 m gray6 \",\n", string);
  fprintf(f_xpm, " \" 95 s 0.95%s c gray5 g4 gray5 g gray5 m gray5 \",\n", string);
  fprintf(f_xpm, " \" 96 s 0.96%s c gray4 g4 gray4 g gray4 m gray4 \",\n", string);
  fprintf(f_xpm, " \" 97 s 0.97%s c gray3 g4 gray3 g gray3 m gray3 \",\n", string);
  fprintf(f_xpm, " \" 98 s 0.98%s c gray2 g4 gray2 g gray2 m gray2 \",\n", string);
  fprintf(f_xpm, " \" 99 s 0.99%s c gray1 g4 gray1 g gray1 m gray1 \",\n", string);
  fprintf(f_xpm, " \"100 s 1.00%s c black g4 black g black m black \",\n", string);
}

/* output routine for xpm X-window display tool

 if mapfire value is 0, then not burned, show maphab value thru
 if mapfire value gt 0, then burning, add # of hab cats to mapfire
 if mapfire value lt 0, then burned, will be * */
#ifdef G77
void writexpmsevmap_(int *ifile, int *istarts, int *imov, int *jcol,
		    int *irow, short int *maphab, int *maxprr, 
		    short int *mapfire)
#else
void writexpmsevmap(int *ifile, int *istarts, int *imov, int *jcol,
		    int *irow, short int *maphab, int *maxprr, 
		    short int *mapfire)
#endif
{
  char fn[100];
  FILE *f_xpm;
  int i, j;
  int *temp = (int*) malloc(*maxprr * sizeof(int) );
  int mapF;

  /* output map */
  sprintf(fn, "sev%d.xpm", *ifile);
  printf("XPM severity map file \"xpm.%d\" generated at %12.6g hours\n",
         *ifile, (float) (*imov) / 360.0);
  f_xpm = fopen(fn, "w");
  fprintf(f_xpm, "/* XPM */\n");
  fprintf(f_xpm, "/* firemap pixmap */\n");
  fprintf(f_xpm, "static char *firemap[] =\n{\n");
  fprintf(f_xpm, "/* cols rows ncolors chars_per_pixel */\n");
  fprintf(f_xpm, " \"%6d %6d 111 3 0 0\",\n", *jcol, *irow);
  WriteGrayScale(f_xpm, "sev");
  fprintf(f_xpm, " \"101 c white    m white  s NotFlammable \",\n");
  fprintf(f_xpm, " \"102 c GreenYellow       m gray70  s LP0 \",\n");
  fprintf(f_xpm, " \"103 c LawnGreen         m gray60 s LP1 \",\n");
  fprintf(f_xpm, " \"104 c LimeGreen         m gray50   s LP2 \",\n");
  fprintf(f_xpm, " \"105 c ForestGreen       m gray40   s LP3 \",\n");
  fprintf(f_xpm, " \"106 c yellow    m gray80  s NF \",\n");
  fprintf(f_xpm, " \"107 c blue    m black  s water \",\n");
  fprintf(f_xpm, " \"108 c red       m white  s burn1 \",\n");
  fprintf(f_xpm, " \"109 c orange    m lightgray s burn2 \",\n");
  fprintf(f_xpm, " \"110 c magenta    m gray   s ignpt \",\n");
  fprintf(f_xpm, "/* pixels */\n");

  for (i = 0; i < *irow; i++) {
    for (j = 0; j < *jcol; j++) {
      mapF = mapfire[j * *maxprr + i]; /* shortcut reference */
      if (mapF < 0) /* cell has burned */
	temp[j] = -mapF;
      else if (mapF == 0) /* cell is unburned */
	temp[j] = maphab[j * *maxprr + i] + 101;
      else if (mapF > 0 && mapF != 8) /* cell is burning */
	/*                temp(j) = mapfire(i,j) + ihab + 1 + 101 */
	temp[j] = 108;
      else /* cell is ignition point */
	temp[j] = 109;
    }
    fprintf(f_xpm, " \"");
    for (j = 0; j < *jcol; j++) {
      fprintf(f_xpm, "%3d", temp[j] );
    }
    fprintf(f_xpm, "\",\n");
  } /* end of loop over i */

  fprintf(f_xpm, "};\n");
  fclose(f_xpm);
  free(temp);
}

#ifdef G77
void writexpmriskmap_(int *imov, int *jcol, int *irow, short int *mc, 
                     int *nrep, int *maxprr, short int *maphab, 
                     short int *mapprob)
#else
void writexpmriskmap(int *imov, int *jcol, int *irow, short int *mc, 
                     int *nrep, int *maxprr, short int *maphab, 
                     short int *mapprob)
#endif
{
  FILE *f_xpm;
  int i, j;
  int *temp = (int*) malloc(*maxprr * sizeof(int) );
  char fn_rsk[100];
  int mapP;

  strcpy(fn_rsk, "risk.xpm");
  printf("XPM risk map file \"%s\" generated at %12.6g hours\n", fn_rsk, 
	 (float) *imov/ 360.0);
  f_xpm = fopen(fn_rsk, "w");
  fprintf(f_xpm, "/* XPM */\n");
  fprintf(f_xpm, "/* riskmap pixmap */\n");
  fprintf(f_xpm, "static char *riskmap[] =\n{\n");
  fprintf(f_xpm, "/* cols rows ncolors chars_per_pixel */\n");
  fprintf(f_xpm, " \"%6d %6d 108 3 0 0\",\n", *jcol, *irow);
  WriteGrayScale(f_xpm, "prob");
  fprintf(f_xpm, " \"101 c white    m white  s NotFlammable \",\n");
  fprintf(f_xpm, " \"102 c GreenYellow       m gray70  s LP0 \",\n");
  fprintf(f_xpm, " \"103 c LawnGreen         m gray60 s LP1 \",\n");
  fprintf(f_xpm, " \"104 c LimeGreen         m gray50   s LP2 \",\n");
  fprintf(f_xpm, " \"105 c ForestGreen       m gray40   s LP3 \",\n");
  fprintf(f_xpm, " \"106 c yellow    m gray80  s NF \",\n");
  fprintf(f_xpm, " \"107 c blue    m black  s water \",\n");
  fprintf(f_xpm, "/* pixels */\n");
  
  for (i = 0; i < *irow; i++) {
    for (j = 0; j < *jcol; j++) {
      mapP = mapprob[j * *maxprr + i]; /* shortcut reference */
      if (mapP < 0) /* this is ignition pt */
	temp[j] = 101;
      else if (mapP == 0) /* this is unburned pt */
	temp[j] = maphab[j * *maxprr + i] + 101;
      else {  /* this is burned pt */
        if (*mc == 1)
          temp[j] = (mapP * 100) / 25;
        else
          temp[j] = (mapP * 100) / *nrep;
      }
    }
    fprintf(f_xpm, " \"");
    for (j = 0; j < *jcol; j++) {
      fprintf(f_xpm, "%3d", temp[j] );
    }
    fprintf(f_xpm, "\",\n");
  } /* end of loop over i */

  fprintf(f_xpm, "};\n");
  fclose(f_xpm);
  free(temp);
}

