c**********************************************************************
       subroutine statinit
c       implicit real*4 (a-h,o-z)
       implicit none
       include 'parm.i'
       include 'common.i'
       integer*4 i
c
c
c  initialize statistical registers
       do i = 1, 20
           xsum(i)  = 0.0
           xsscp(i) = 0.0
           xmin(i)  = 1.e9
           xmax(i)  = 0.0
           lbl(i)   = ' '
       enddo
c
       lbl(1) = ' LP0  1'
       lbl(2) = ' LP1  2'
       lbl(3) = ' LP2  3'
       lbl(4) = ' LP3  4'
       lbl(5) = '  NF  5'
       lbl(6) = 'Type  6'
       lbl(7) = 'Type  7'
       lbl(8) = 'Type  8'
       lbl(9) = 'Type  9'
       lbl(10) = 'Type  10'
c
       return
       end
c
c**********************************************************************
       subroutine accumstats
c
c       implicit real*4 (a-h,o-z)
       implicit none
       include 'parm.i'
       include 'common.i'
       integer*4 i
       real*4 vicdf
c
c
       call cdf
       do i = 1, ihab
c
c  normalize to obtain percent of landscape in each fuel type burned
c          vicdf = (float(icdf(i)) / float(irow*jcol))*100.0
c   use this to get percent burned of each fuel type
          vicdf = (float(icdf(i)) / float(iburned))*100.0
          call sscp (i, vicdf)
       enddo
c
       return
       end
c
c**********************************************************************
       subroutine cdf
c
c       implicit real*4 (a-h,o-z)   
       implicit none
       include 'parm.i'
       include 'common.i'
c
c
       integer*2 icnt 
       integer*4 i, j
c
c  look at map and create cumulative frequency distribution
c    of burned or burning cells
c
c        zero all icdf
       do i = 0, ihab
         icdf(i)  = 0 
       enddo
c
       do j = 1, jcol
          do i = 1, irow
             if (mapfire(i,j) .ne. 0) then
c                 count to pointer
                icnt = maphab(i,j)
c                 increment pointer's register
                icdf(icnt) = icdf(icnt) + 1
             endif
          enddo
       enddo
c
c       print *, "here is next icdf - should sum to iburned"
c       do i = 0, ihab
c         print *, "icdf =", icdf(i)
c       enddo
c
       return
       end
c
c**********************************************************************

       subroutine sscp (ist, value)
c
c       implicit real*4 (a-h,o-z)   
       implicit none
       include 'parm.i'
c
       integer*4 ist, maxradbn, maxradbd
       real*4 xsum, xsscp, xmin, xmax, value, sumr, sumrsqd, bsumr
       real*4 bsumrsqd, slopefct, slopemax, sevmax, sevmin, chkwave
       character*12 lbl
       common/blkst / xsum(26), xsscp(26), xmin(26), xmax(26), lbl(26),
     & sumr, sumrsqd, bsumr, bsumrsqd, slopefct, slopemax,
     & maxradbn, maxradbd, sevmax, sevmin, chkwave
c
c  obtain sum
       xsum(ist) = xsum(ist) + value
c
c  obtain sum of cross products
       xsscp(ist) = xsscp(ist) + value*value
c
c  find min and max
       if (value .lt. xmin(ist)) xmin(ist) = value
       if (value .gt. xmax(ist)) xmax(ist) = value
c
       return
       end
c
c**********************************************************************
       subroutine statsout
c
c     implicit real*4 (a-h,o-z)   
       implicit none
       include 'parm.i'
       include 'common.i'
       integer*4 i
       real*4 xmean, var, std, cv
c
c  output statistical results
       write(*, 840) irep
840       format (//20x,'% Burned of Total Burned (rep #  = ',i3,')'/
     &'Fuel Type',10x,'Mean',8x,'St.Dev.',5x,'C.V.',7x,
     &'Minimum',5x,'Maximum')
c
       do i = 1, ihab 
            xmean = xsum(i) / nrep
            var   = xsscp(i) - xsum(i)*xsum(i)/nrep
            if (var .gt. 0.0 .and. nrep .gt. 1) then
               std = sqrt (var / (nrep - 1))
              else
               std = 0.0
            endif
            cv    = 0.0
            if (std .gt. 0.0) cv = std / xmean * 100.0
            if (xmin(i) .gt. xmean) xmin(i) = xmean
            write(*, 841) lbl(i), xmean, std, cv, xmin(i), xmax(i)
841         format (1x,a12,5(2x,f10.4))
          enddo
c
            write(*, 888)
888         format (//)
c
c
       write(*, 5)
5      format(' Burned Cell Totals:'/)
c
c
       write(*, 103)
103    format ('    Not                                      N',
     &  'ot')
       write(*, 105)
105    format (t4,' Flam     LP0     LP1     LP2     LP3  For',
     &  'est'/)
c
       write(*, 10) (icdf(i),i=0,ihab)
10     format(/20(1x,i7))
c
           return
           end
c
c**********************************************************************
       subroutine writedata
c
c       implicit real*4 (a-h,o-z)   
       implicit none
       include 'parm.i'
       include 'common.i'
       integer*4 i
c
       real*4 vicdf(0:20)
c
c
       call cdf
       do i = 1, ihab
c
c  normalize to obtain percent
c          vicdf(i) = (float(icdf(i)) / float(irow*jcol))*100.0
          vicdf(i) = (float(icdf(i)) / float(iburned))*100.0
       enddo
c
c  output results
c       write (11,100) irep, float(imov(2))/360., (icdf(i),i=1,ihab)
c100    format (1x,i4,1x,g12.6,20(1x,i6))
       write (11,100) irep, float(imov(2))/360., (vicdf(i),i=1,ihab)
100    format (1x,i4,1x,f12.6,20(1x,g12.6))
c
       call radiusout
c
       return
       end
c
c**********************************************************************
       subroutine writelabel
c
c      not used presently
c
c       implicit real*4 (a-h,o-z)   
       implicit none
       include 'parm.i'
c
       include 'common.i'
c
c  write label on output data set
       write (11,100) simlen,ifcnt,nrep
100    format (' Simlen= ',i5,' #_Fires', i5,' Reps ',i5)
       write (11,101) nrep, ifcnt, simlen
101    format (4i10)
c
       return
       end
c
c**********************************************************************
       subroutine radiusout
c
c       implicit real*4 (a-h,o-z)
       implicit none
       include 'parm.i'
       include 'common.i'
       integer*4 i
       real*4 rsqd
c
c  write on output data set
       if (ifcnt .gt. 0) then
          write (10,102) irep, float(imov(2))/360., float(ifcnt),
     &     float(iburned)
102       format ($,i3,2x,g12.6,2x,g12.6,2x,g12.6)
c
c if only 1 start, write radius info
          if (istarts .eq. 1) then
c
c           for every burning pixel in the stack
c            get radius from first ignition point
c            square and accumulate
c            accumulate
c
c            preserve maximum radius travelled by burned,
c             maximum radius travelled by burning
c
             maxradbn = 0
             do i = 1,ifcnt
                rsqd = (iburning(i)-mstart(1,1))**2 +
     &          (jburning(i)-mstart(1,2))**2
                if (maxradbd .lt. iburning(i)-mstart(1,1)) maxradbd =
     & iburning(i)-mstart(1,1)
                if (maxradbd .lt. jburning(i)-mstart(1,2)) maxradbd =
     & jburning(i)-mstart(1,2)
                if (maxradbn .lt. iburning(i)-mstart(1,1)) maxradbn =
     & iburning(i)-mstart(1,1)
                if (maxradbn .lt. jburning(i)-mstart(1,2)) maxradbn =
     & jburning(i)-mstart(1,2)
                sumrsqd = sumrsqd + rsqd
                sumr = sumr + sqrt(rsqd)
             enddo
             bsumr = bsumr + sumr
             bsumrsqd = bsumrsqd + sumrsqd
c
             write (10,103) sqrt(sumrsqd/ifcnt), sumr/ifcnt,
     &        sqrt(bsumrsqd/iburned), bsumr/iburned, maxradbn,
     &        maxradbd
103           format (2x,f10.2,2x,f10.2,f10.2,2x,f10.2,2x,i6,2x,i6)
          else		! more than one start
c            finish line w carriage return
             write (10,104)
104          format ()
          endif
       endif		! ifcnt .gt. 0
c
       return
       end
c**********************************************************************
