c**********************************************************************
      subroutine movfire
c
c      implicit real*4 (a-h,o-z)
      implicit none
      include 'parm.i'
      include 'common.i'
      integer*4 n, iclock, iparents, m, ii, jj, mmo, mday, mhr, mmin, i
      integer*4 msec, ntime, imonths, iweeks, idays, ihrs, imins, isecs
      integer*4 j, k, itime
      integer*4 drawpixmap
      external drawpixmap
c
c
c  time and date notes for movfire
c
c  imov is the master record of time, and consists of a 2-element array.
c  imov(1) represents the current calendar year
c  imov(2) represents the # of 10-second timesteps since the first
c   ignition this year.  elapsed time is always from the first ignition
c   of the current season.
c  imov [cal yr] [# timesteps since istime]
c
c  istime is #secs to first ignition of this season.  istime is updated
c   to first ignition at eos.
c
c  ifirst is the calendar year and # seconds of the very first ignition.
c  ifirst is a 2-element array like imov, but the units are seconds.
c  ifirst is kept so that total multi-season elapsed time can be
c   calculated.
c  ifirst(1) represents cal yr of the first ignition
c  ifirst(2) represents # seconds to first ign first year
c  ifirst [cal yr] [#sec to first ignition the first year]
c
c  inextign, inextwx, and kclock are all intervals of 10-second timesteps
c  spreadmat, lastclk, and burntime are all intervals of 10-sec timesteps
c
c  readign tests for season change.  upon season change, currently
c   burning fires are allowed to burn out, with weather changes as
c   necessary.
c
c
      if (ifcnt.le.0) return           !if no fire sites burning now
c
c
c     initialize imov year
      imov(1) = ifirst(1)
      imov(2) = 0
c
c  reset edge detect flags
      edgenbr = 0
      edgefb = 0
c
c  nrep = # of replicates
c  irep = current replicate
c  imov = # of moves that have taken place
c  istarts = number of fire starts
c  ifcnt = total number of fire sites burning now
c  ifcnt initialized in beginfiresim
c  ifb = # of firebrands thrown
c  ifbno(ihab) = # of firebrands thrown from this habitat type?
c
      if (intout .eq. 'Y' .and.
     &  habout .eq. 'Y') then
c  output initial habitat map of proper format
         if (outfmtans .eq. 'X') then
            call xpmsevmap
         else if (outfmtans .eq. 'G') then
            call grassmap
         else
            call rulemap
         endif
c
         write(*,72)
72       format (t10,'Output map generated for initial habitat')
      endif
c
      write(*,73) irep, nrep
73    format ('Replication ',i6,' of ',i6,' starting')
c
c      print*,'Before first main loop,'
c      print *,'inextwx = ',inextwx
c      print *,'inextign = ',inextign
c**********************************************************************
c
c  main loop:
c  event-driven, variable time-step, all children clock-driven
c
c  order of events is:
c
c  determine event that happens next
c  last pass thru stack got minimum clock(fastest old fire) in inextclk
c  take least of inextwx, inextign, and clock - this is iclock
c
c  then, one of 4 mutually-exclusive events occurs:
c
c  1)  next event is weather change
c        spread old fires up to weather change
c        do weather
c        normalize clocks for next timestep
c
c  or
c
c  2)  next event is weather change and ignition (or 3-way)
c        spread old fires up to weather change and ignition
c        do weather
c        normalize clocks for next timestep
c        do ignition with new weather
c
c  or
c
c  3)  next event is ignition only
c        spread old fires up to ignition
c        do ignition with current weather
c
c  or
c
c  4)  next event is fast old fire spread
c        spread old fires
c
c
c  spreading old fires consists of:
c
c    increment time
c    preserve # of parent fires
c    over all parent fires
c    decrement kclock by time that has passed
c    if kclock is 0, spread this parent
c    call popit
c    write data
c    test if done
c    loop to increment time
c
c
c  3 potential passes thru burning cells stack per variable timestep:
c   1) to spread parent fires
c   2) to pop dead fires off the stack and get smallest kclock
c       for next timestep
c
c   3) to renormalize for weather change (if necessary) and get
c       smallest normalized kclock for next timestep
c
c
c  make pass thru stack and get minimum kclock
c  for first time thru
      inextclk = 99999999
      do n = 1, ifcnt
         if (kclock(n) .lt. inextclk) inextclk = kclock(n)
      enddo
c
c
c
18    continue			! simulation continues
c
c  determine next event
c
c  next step will be smaller of fastest fire or next wx change
c   or next fire start (if multiple starts through time)
c
c  take least of inextwx, inextign, and kclock as inextclk
      if (wxtype .eq. 'I' .and. inextwx .lt. inextclk)
     & inextclk = inextwx
      if (ignans .eq. 'Y' .and. inextign .lt. inextclk)
     & inextclk = inextign
c
c      print *,'After seeking lowest, inextclk is ',inextclk
c      print *,'inextwx = ',inextwx
c      print *,'inextign = ',inextign
c
c
c
c  spread old fires with that inextclk
c
c   iparents = number of existing parent fires burning now
c   iburning() and jburning() = vectors of x,y locations of burning fires
c   m = parent fire index number
c
c   initialize stat accumulators
      sumrsqd = 0.0
      sumr = 0.0
c
c
      iclock = inextclk         ! set timestep for this move
c      print *,'Next clock step is ',iclock
c
c
      imov(2) = imov(2) + iclock
c
c
      iparents = ifcnt          ! preserve count of parent fires
c      print *, 'There are ', iparents, ' parents'
c
      do m = 1, iparents        ! over all parents
         kclock(m) = kclock(m) - iclock ! decrement by this timestep
         if (kclock(m) .eq. 0) then     ! time to spread this parent
            ii = iburning(m)
            jj = jburning(m)
            if (fbans .eq. 'Y') call firebrand (ii, jj)
c            print *, 'Spreading the ',m,' parent ',ii,jj
c            print *,'ifcnt is ',ifcnt,' before call to neighfire'
c          try to burn the neighborhood - spread this fire
            call neighfire (ii, jj)
c            print *,'ifcnt is ',ifcnt,' after neighborhood spread'
c          increment age of each surviving parent fire
            if (mapfire(ii,jj) .gt. 0) mapfire(ii,jj)=mapfire(ii,jj)+1
c
         endif  ! time to spread this parent
      enddo     ! over all parents
c
cc   remove fires with kclock = 0
cc      print *,'Calling popit'
c      call popit
c
c**********************************************************************
c
c  calculate current date
c       if (waveans .eq. 'Y' .and.
c     &   float(imov(2))/6 .ge. (chkwave*ivis)) then
c
       if (waveans .eq. 'Y') then
          if (istime .gt. 0) then          ! particular start date
             itime = (imov(2)*10)+istime
             call datetime(itime,imov(1),
     &        mmo,mday,mhr,mmin,msec)
c              print *,'imov(1) is', imov(1)
c              print *,'imov(2) is', imov(2)
c              print *,'istime is', istime
c              print *,'mhr is', mhr
c              print *,'mmin is', mmin
             ntime = timedate(imov(1),mmo,mday,mhr,mmin,msec)
c             print *,'check ntime is ',ntime
c             print *,'should equal this ',(imov(2)*10)+istime
             write(*, 778) mhr,mmin,msec,mmo,mday,imov(1)
778          format (t10,"it is now ",i2,":",i2,":",i2," on ",
     &        i2,"/",i2,"/",i4)
          endif
c
c
          if (wxtype .ne. 'U') then
             if (ispeed .eq. 0) then
                write(*, 211) iclimate
211             format(t10,'No wind ',
     &           '  with fuel moisture class ',i1)
             else
                write(*, 222) idir, ispeed, iclimate
222             format(t10,'Wind from ',i1,'  at speed class ',i1,
     &           '  with fuel moisture class ',i1)
             endif
          endif
c
c
c         if visualization requested, print screen prompts
          write(*, 202) ifcnt
202       format (t10,i20,' cells are burning,')
          write(*, 203) iburned
203       format (t10,i20,' cells have burned')
c
c
c  calculate time elapsed and print to screen
c
          imonths = imov(2)/241920
          iweeks = (imov(2)-(imonths*241920))/60480
          idays = (imov(2)-(iweeks*60480)-(imonths*241920))/8640
          ihrs = (imov(2)-(idays*8640)-(iweeks*60480)-
     &     (imonths*241920))/360
          imins = (imov(2)-(ihrs*360)-(idays*8640)-(iweeks*60480)-
     &     (imonths*241920))/6
          isecs = (imov(2)-(imins*6)-(ihrs*360)-(idays*8640)-
     &     (iweeks*60480)-(imonths*241920))*10
c
          if (imov(2) .lt. 6) then
             write(*, 99991) isecs
99991        format (6x,'        ',1x,'     ',1x,'      ',2x,'     ',
     &        2x,'      ',i2,' secs have elapsed')
          else if (imov(2) .lt. 360) then
             write(*, 99992) imins, isecs
99992        format (6x,'        ',1x,'     ',1x,'      ',2x,'     ',
     &        i2,' mins ',i2,' secs have elapsed')
          else if (imov(2) .lt. 8640) then
             write(*, 99993) ihrs, imins, isecs
99993        format (6x,'        ',1x,'     ',1x,'      ',i2,' hrs ',
     &        i2,' mins ',i2,' secs have elapsed')
          else if (imov(2) .lt. 60480) then
             write(*, 99994) idays, ihrs, imins, isecs
99994        format (6x,'        ',1x,'     ',i1,' days ',i2,' hrs ',
     &        i2,' mins ',i2,' secs have elapsed')
          else if (imov(2) .lt. 241920) then
             write(*, 99995) iweeks, idays, ihrs, imins, isecs
99995        format (6x,'        ',i1,' wks ',i1,' days ',i2,' hrs ',
     &        i2,' mins ',i2,' secs have elapsed')
          else
             write(*, 99996) imonths, iweeks, idays, ihrs, imins,
     &        isecs
99996        format (i6,' months ',i1,' wks ',i1,' days ',i2,' hrs ',
     &        i2,' mins ',i2,' secs have elapsed')
          endif
          if (imov(1) .ne. 0) then
             write(*, 99997) imov(1)
99997        format (/t45' in the ',i4,' fire season')
          endif
c
       endif	! visualization is requested
c
c**********************************************************************
c     is there changing weather?
      if (wxtype .eq. 'I') then
c        is it time for a weather change?
         if (iclock .eq. inextwx) then        ! time to change wx now
c           set this weather, look ahead for next wx and interval
c            print *, 'Calling readwx'
            call readwx
c
c           normalize clocks of burning fires for this weather
c
c           if new wx, renormalize kclock for these weather conditions
c            time left / old weather countdown total =
c            new time left / new weather countdown total
c           lastsprd is rate for penultimate weather condx
c            must update it to current wx condx after normalizing kclock
c           lastclk is last renormalized kclock
c           burntime stores how long this cell burned
c            must update it before renormalizing lifetime for new wx
c
c           get minimum clock (fastest old fire) for next timestep
c            while you're here
c
            inextclk = 99999999
            do n = 1, ifcnt
               ii = iburning(n)
               jj = jburning(n)
               burntime(n)=burntime(n)+(lastclk(n)-kclock(n))
               kclock(n)=nint((float(kclock(n))*
     &          float(spreadmat(iclimate,maphab(ii,jj),ispeed)))/
     &          float(lastsprd(n)))
               lastclk(n) = kclock(n)
               lastsprd(n) = spreadmat(iclimate,maphab(ii,jj),ispeed)
               if (kclock(n) .lt. inextclk) inextclk = kclock(n)
            enddo
c
         else	! continue countdown to next wx change
c
c            print *,'Continuing wx countdown'
c            print *,'iclock is ',iclock
            if(inextwx .ne. 99999999) inextwx=inextwx-iclock
         endif
c
      else      ! wx not changing
c
c        pick a large minimum
         inextwx = 99999999
c
      endif
c
c
c**********************************************************************
c     are there multiple starts thru time?
      if (ignans .eq. 'Y') then
c        is it time for the next ignition?
         if (iclock .eq. inextign) then        ! time for next ign now
c           perform ignition & get interval to next ignition
c            print*,'Calling readign from main loop'
            call readign
c
         else		! continue countdown to next ign
c
c           countdown if there are more ignitions,
c            and it is not end-of-season
            if (inextign .ne. 99999999 .and. iseos .ne. 1)
     &       inextign=inextign-iclock
         endif
c
      endif
c
c**********************************************************************
c
c   remove fires with kclock = 0
c      print *,'Calling popit'
      call popit
c
c**********************************************************************
c
c
c      print some blank lines
       if (waveans .eq. 'Y') write(*, 525)
525    format (///)
c
c  write out data if not generating a risk map
       if (riskans .ne. 'Y') call writedata
c
c
c goto visualization tool for output at interval specified by chkwave
c          print *,float(imov(2))/6, (chkwave*ivis)
       if (waveans .eq. 'Y' .and.
     &  float(imov(2))/6 .ge. (chkwave*ivis)) then
c          print *,'imov(2)=',imov(2),' chkwave=',chkwave
c
          do i=1, istarts
             mapfire(mstart(i,1),mstart(i,2)) = 8
          enddo
c
          k=0
          do i=1,irow
             do j=1,jcol
                if (mapfire(i,j) .lt. 0) then
                   idispvec(k) = mapfire(i,j)
                else if (mapfire(i,j) .eq. 0) then
                   idispvec(k) = maphab(i,j)
                else if(mapfire(i,j).gt.0 .and. mapfire(i,j).ne.8) then
                  idispvec(k) = mapfire(i,j) + ihab + 1
                else
                   idispvec(k) = 8
                endif
                   k=k+1
             enddo
          enddo
          ipixid=ipixids(2)
          ierr=drawpixmap(ipixid,jcol,irow,idtype,idispvec,
     & idumm,mapcolor,firetitle)
          ivis = ivis + 1
          if (ierr .lt. 0) call pixmaperror(ierr)
         write(*, 775)
775      format (t10,'Burn map displayed; ')
         if (wxtype .eq. 'I') call indicator
       endif	! time to visualize map
c
       if (intout .eq. 'Y' .and.
     &   float(imov(2))/360 .ge. (outfreq*iouts)) then
c  output intermediate map of proper format
          iouts = iouts + 1
          if (outfmtans .eq. 'X') then
             call xpmsevmap
          else if (outfmtans .eq. 'G') then
             call grassmap
          else
             call rulemap
          endif
       endif
c
c
c
c  determine if simulation is finished
c
       if (ifcnt .gt. (irow*jcol)) then
           write(*, 101) ifcnt
101        format (t15,'More current fires burning than pixels - ',
     & 'simulation aborted: ifcnt = ',i6/)
           return
       endif
c
       if (ifcnt .le. 0) then
c  if all fires are out, but there are multiple starts thru time, and
c   there are more starts to go yet, jump time forward, do the
c   ignitions, set the weather, and jump back to the main loop
c   otherwise, clean up and end
          if (ignans .eq. 'Y' .and.
     &  inextign .ne. 99999999) then	! more ignitions
             if (iseos .eq. 1) then	! end-of-season
c
c               visualize fire map at eos
c
                if (waveans .eq. 'Y') then
                   ivis = 1
                   iouts = 1
c
                   do i=1, istarts
                      mapfire(mstart(i,1),mstart(i,2)) = 8
                   enddo
c
                   k=0
                   do i=1,irow
                      do j=1,jcol
                         if (mapfire(i,j) .lt. 0) then
                            idispvec(k) = mapfire(i,j)
                         else if (mapfire(i,j) .eq. 0) then
                            idispvec(k) = maphab(i,j)
                         else if(mapfire(i,j).gt.0 .and.
     &                    mapfire(i,j).ne.8) then
                            idispvec(k) = mapfire(i,j) + ihab + 1
                         else
                            idispvec(k) = 8
                         endif
                            k=k+1
                      enddo
                   enddo
                   ipixid=ipixids(2)
                   ierr=drawpixmap(ipixid,jcol,irow,idtype,idispvec,
     &              idumm,mapcolor,firetitle)
                   if (ierr .lt. 0) call pixmaperror(ierr)
                  write(*, 771) imov(1)
771               format (t10,'Burn map displayed for end of ',
     &             i4,' season')
                endif	! waveans is 'Y'
c
c
c               file output at end of season
                if (intout .eq. 'Y') then
c                  output intermediate map of proper format
                   iouts = iouts + 1
                   if (outfmtans .eq. 'X') then
                      call xpmsevmap
                   else if (outfmtans .eq. 'G') then
                      call grassmap
                   else
                      call rulemap
                   endif
                endif
c
c
                if (mc .eq. 1) then
c                  add this result to risk probability map
                   print*,'Adding result to risk map'
                   do j=1,jcol
                      do i=1,irow
                         if (mapfire(i,j) .ne. 0)
     &                    mapprob(i,j)=mapprob(i,j)+1
                      enddo
                   enddo
c
                   iadd = iadd + 1
c
                   do i=1, istarts
                      mapprob(mstart(i,1),mstart(i,2)) = -1
                   enddo
c
c temporary
c                   print*,'Displaying risk map'
c                   k=0
c                   do i=1,irow
c                      do j=1,jcol
c                         if (mapprob(i,j).lt.0) then   ! this is ignition pt
c                            idispvec(k) = 101
c                         else if (mapprob(i,j).eq.0) then  ! unburned pt
c                            idispvec(k) = maphab(i,j)+101
c                         else                             ! burned pt
c                            idispvec(k) = (mapprob(i,j)*100)/25
c                         endif
c                         k=k+1
c                      enddo
c                   enddo
cc
cc                  get the right pixmap to display in
c                   if (iadd .eq. 1) then
c                      ipixid = -1
c                   else
c                      ipixid = ipixids(3)
c                   endif
cc                   print*,'ipixid is ', ipixid
cc                   print *,ipixid,jcol,irow,idtype,idumm,probcolor,
c     &              probtitle
c                   ierr=drawpixmap(ipixid,jcol,irow,idtype,idispvec,
c     &              idumm,probcolor,probtitle)
c                   ipixids(3)=ipixid
c                   if (ierr .lt. 0) call pixmaperror(ierr)
c
                endif	! monte carlo
c
c               write eos stats
                call accumstats
                call statsout
                call landstat
c
                if (mc .eq.1) then
c                  re-zero fire map from previous rep
                   do j = 1, jcol
                      do i = 1, irow
                         mapfire(i,j) = 0
                      enddo
                   enddo
c
                   iburned = 0
                   edgenbr = 0
                   edgefb = 0
c
                endif
c
c               update habitat map
c               no habitat regrowth in early runs
c                call updatehab
c
c               increment year count by difference in years
                imov(1) = imov(1) + (lststyr-imov(1))
c               rezero imov(2) for new season
                imov(2) = 0
c                print*,'imov(1) is',imov(1)
c                print*,'imov(2) is',imov(2)
c
c               update istime to first ignition this season
                istime = inextign*10
c
c               find and set weather
c               no burning cells, so no need to renormalize stack
                call findwx((imov(2)*10)+istime)	! same as istime
c
c               set next ignitions
c                print*,'Calling readign from eos'
                call readign
c
                iseos = 0
c
c               do minimum search thru stack for fastest new start
                inextclk = 99999999
                do n = 1, ifcnt
                   if (kclock(n) .lt. inextclk) inextclk = kclock(n)
                enddo
c
c               jump back to main loop
                goto 18
c
             else		! do stuff for next start this season
c
c               next timestep steps up to next ignition
                imov(2) = imov(2) + inextign
c
c               find and set next weather
                itime = (imov(2)*10)+istime
             call datetime(itime,
     &        imov(1),mmo,mday,mhr,mmin,msec)
             write(*, 752) mhr,mmin,msec,mmo,mday,imov(1)
752          format (t10,"calling findwx for ",i2,":",i2,":",i2," on ",
     &        i2,"/",i2,"/",i4)
c               no burning cells, so no need to renormalize stack
                call findwx((imov(2)*10)+istime)
c
c               set next ignitions
c                print*,'Calling readign'
                call readign
c
c               do minimum search thru stack for fastest new start
                inextclk = 99999999
                do n = 1, ifcnt
                   if (kclock(n) .lt. inextclk) inextclk = kclock(n)
                enddo
c
c               jump back to main loop
                goto 18
c
             endif	! end-of-season
c
          endif		! no time sequence starts or no more ignitions
c
c
          write(*, 201) float(imov(2))/360.
201       format (t15,'Simulation finished - all fires gone out',
     & ' after ',g12.6,' hours'/)
          goto 63
       endif
c
c  was edge of map reached?
       if (edgefb .eq. 1) then
           write(*, 105)
105        format (t15,'Simulation stopped - edge reached by
     & firebrand'/)
           goto 63
       endif
c
       if (edgenbr .eq. 1) then
           write(*, 212)
212        format (t15,'Simulation stopped - edge reached by
     & neighborhood'/)
           goto 63
       endif
c
       if (maxfiresend .eq. 1) then
           write(*, 213) ifcnt
213        format (t15,'Simulation stopped: # pixels ',
     & 'burning = ',i6/)
           goto 63
       endif
c
       if (maxburnedend .eq. 1) then
           write(*, 214) iburned
214        format (t15,'Simulation stopped: # pixels ',
     & 'burned = ',i6/)
           goto 63
       endif
c
c       if (imov(2) .ge. maxmov) then
c           write(*, 102)
c102        format (t15,'Simulation stopped - time limit reached'/)
c           goto 63
c       endif
c
       if (stoptype .eq. 'T' .and. float(imov(2))/360 .ge. simlen) then
           write(*, 103) float(imov(2))/360.
103        format (t15,'Simulation concluded after ',g12.6,' hours')
           goto 63
       endif
c
c  simulation continues
       goto 18
c
c--------------------------------------------------------------------
c
63     continue
c
c  ***************** simulation ends ***************
c
        if (mc .eq. 1) then
c  add this result to risk probability map
           print*,'Adding result to risk map'
           do j=1,jcol
              do i=1,irow
                 if (mapfire(i,j) .ne. 0) mapprob(i,j)=mapprob(i,j)+1
              enddo
           enddo
           iadd = iadd + 1
        endif
c
c  if multiple seasons, calculate total elapsed time across seasons
       if (imov(1) .gt. ifirst(1)) call elapsed
c
c  write separator blank line to cfd.scratch and radius.scratch
       write (10,114)
114    format ()
       write (11,115)
115    format ()
c
c  output final burn map of proper format
       if (outans .eq. 'Y') then
          ifile = 33
          if (fmtans .eq. 'X') then
             call xpmsevmap
          else if (fmtans .eq. 'G') then
             call grassmap
          else
             call rulemap
          endif
       endif
c
c  reset year to start
       imov(1) = ifirst(1)
c
       return
       end
c**********************************************************************
c
       subroutine updatehab
c not currently used, but maybe later
c
c       implicit rceal*4 (a-h,o-z)   
       implicit none
       include 'parm.i'
       include 'common.i'
cc
cc  calculate markov probabilities if not already done
c       if (done .ne. 1) then
c          do i=1, 525
cc
cc  calculate percentage of stands this age in each fuel type
cc            this is lp1
c             plp(3) = 
c     & 0.39134066+77.180811*exp(-exp(-((i-99.578931)/38.406142))-
c     & ((i-99.578931)/38.406142)+1.)
cc
cc            this is lp2
c             plp(4) =
c     & -126.3947+199.33575/(1.+((i-274.47634)/321.33606)^2.)
cc
cc            this is lp3
c             plp(5) =
c     & 1./(-0.0017008348+3183.265/i^2.)
cc
cc            this is lp0 by subtraction
c             plp(2) = 100.-(plp1+plp2+plp3)
c                if (plp(2) .lt. 0. .or. i .gt. 125) plp(2) = 0.
cc
c             do j=2, ihab
c                succprob(i,j) =
c     &           plp(j)/(plp(j+1)+plp(j))
c             enddo
cc
c          enddo
cc
cc         set done flag
c          done = 1
c       endif	! not done
cc
cc      go through the habitat map
c       do j = 1, jcol
c          do i = 1, irow
c             if (mapfire(i,j) .ne. 0) then	! it burned
c                if (-mapfire(i,j) .gt. srthresh) then	! stand replacing
cc
cc                  if lp0 burned again, set to nf type
c                   if (maphab(i,j) .eq. 2) then
c                      maphab(i,j) = 1
cc                  not forested stays not forested for now
c                   else if (maphab(i,j) .eq. 1) then
c                      maphab(i,j) = 1
c                   else		! lp1, lp2, lp3 reset to lp0
cc                      maphab(i,j) = 2
cc                   endif
cc                  reset age to zero
c                   mapage(i,j) = 0
cc
c                endif	! not stand-replacing, fuel unchanged
c             else	! didn't burn
cc
cc            advance stands acc to markov probabilities
c             x = ran(iseed)
c             if (x .gt. succprob(mapage(i,j),maphab(i,j))) then
c                maphab(i,j) = maphab(i,j) + 1
c                if (maphab(i,j) .gt. ihab) maphab(i,j) = ihab
c             endif
cc
cc            age unburned cells by one
c             mapage(i,j) = mapage(i,j) + 1
c          enddo
c       enddo
cc
cc  visualize new habitat map
cc
       return
       end
c**********************************************************************
c
       subroutine beginfiresim
c
c       implicit real*4 (a-h,o-z)   
       implicit none
       include 'parm.i'
       include 'common.i'
       integer*4 i, j, ii, jj
       integer*4 ntime
       real*4 getrandom
       external getrandom
c
c
c   3 ways to set simulation start date:
c
c  1)  first start in ignition sequence - done below
c  2)  specify particular start date - done in input.f
c  3)  begin initial fire with first weather record - done in wx below
c
c  all 3 methods result in setting istime, and ifirst(1) and ifirst(2)
c
c
c
c  set up ignition sequence through time, if necessary
       if (ignans .eq. 'Y') then
c
          open (13, file=ignfile,status='old')
          rewind(13)
          print*,'Rewinding ignition'
c
c         read first start time
          istarts = 0
          read (13,1222,end=88888,err=99999) lststyr, lststmo,
     &     lststdy, lststhr, lststmin, lststsec,
     &     mstart(istarts+1,2), mstart(istarts+1,1)
c  changes to this format must be made to 1222 in readign also
1222      format(i4,5x,i2,5x,i2,5x,i2,1x,i2,1x,i2,5x,i4,5x,i4)
c
c         first fire start in sequence starts the clock
          istime = timedate(lststyr, lststmo, lststdy, lststhr,
     &     lststmin, lststsec)
          ifirst(1) = lststyr
          ifirst(2) = istime
c          print *,'istime back from timedate is ', istime
c          print *,'ifirst(1) or lststyr is',ifirst(1)
          write(*, 353) lststhr,lststmin,lststsec,lststmo,lststdy,
     &     lststyr
353       format (t10,"first fire start is at ",i2,":",i2,":",i2,
     &     " on ",i2,"/",i2,"/",i4)
c
c         if both coordinates are 0, this start is random
          if (mstart(istarts+1,1) .eq. 0 .and.
     &     mstart(istarts+1,2) .eq. 0) then
c3            mstart(istarts+1,1) = int(ran(iseed)*jcol) + 1
c             mstart(istarts+1,2) = int(ran(iseed)*irow) + 1
3            mstart(istarts+1,1) = int(getrandom()*jcol) + 1
             mstart(istarts+1,2) = int(getrandom()*irow) + 1
             if (maphab(mstart(istarts+1,1),mstart(istarts+1,2))
     &        .lt. 1 .or. maphab(mstart(istarts+1,1),
     &        mstart(istarts+1,2)) .eq. 6) goto 3
          endif
c
       endif         ! set up ignition sequence through time
c
c
c======================================================================
c
c      read weather if wxtype is i
       if (wxtype .eq. 'I') then
c
          open (30, file=wxfile,status='old')
          rewind(30)
          print*,'Rewinding weather'
c
c          print *, 'istime is ', istime
c          print *, 'ifirst(1) is ', ifirst(1)
c          print *, 'ifirst(2) is ', ifirst(2)
          if (istime .gt. 0) then       ! is a particular start date
c            gets here either from particular start date in input.f
c            or first start in ign sequence above
c            either way, istime, ifirst(1), and ifirst(2) are set
c
             read (30,1000,end=8888,err=9999) nxtwxyr, nxtwxmo, nxtwxdy,
     &        nxtwxhr, nxtwxmin, nxtwxsec, nwd, nws, n10hr, n1000hr
c            this format is paired with one in readwx and findwx
1000         format(i4,5x,i2,5x,i2,5x,i2,1x,i2,1x,i2,5x,a2,5x,i3,5x,
     &        i2,5x,i2)
c
c            are we past the first start?
             ntime = timedate(nxtwxyr,nxtwxmo,nxtwxdy,nxtwxhr,
     &        nxtwxmin,nxtwxsec)
c
             if (nxtwxyr .gt. ifirst(1) .and. ntime .gt. istime) then
c               first wx past first ign
                print *, 'No weather data prior to first ignition!'
                print *,'Starting with first available weather data'
c               class & set weather
                call classwx(nwd,nws,n10hr,n1000hr,idir,ispeed,iclimate)
c               read second record and set next wx
                read (30,1000,end=8888,err=9999) nxtwxyr, nxtwxmo,
     &           nxtwxdy, nxtwxhr, nxtwxmin, nxtwxsec, nwd, nws,
     &           n10hr, n1000hr
                call classwx(nwd,nws,n10hr,n1000hr,ndir,nspeed,nclimate)
c
c               calculate interval to next wx change in 10-sec timesteps
                inextwx = nint((timedate(nxtwxyr,nxtwxmo,nxtwxdy,nxtwxhr
     &           ,nxtwxmin,nxtwxsec) - istime)/10.)
c
             else      ! find wx for first start
c
c               initialize imov year before first call to findwx
                imov(1)=ifirst(1)
c                print*,'Calling findwx from beginfiresim'
c                print*,'with istime of ',istime
                call findwx(istime)
c
             endif     ! initial wx is set up for particular start date
c
          else  ! no particular start date, begin with first weather record
c
c            read first weather
             read (30,1000,end=8888,err=9999) nxtwxyr, nxtwxmo, nxtwxdy,
     &        nxtwxhr, nxtwxmin, nxtwxsec, nwd, nws, n10hr, n1000hr
c            print *, nxtwxyr, nxtwxmo, nxtwxdy, nxtwxhr, nxtwxmin,
c     &       nxtwxsec, nwd, nws, n10hr, n1000hr
c
c            set this wx to next
             call classwx(nwd,nws,n10hr,n1000hr,ndir,nspeed,nclimate)
c
c            set istime to first weather record
             istime = timedate(nxtwxyr,nxtwxmo,nxtwxdy,nxtwxhr,
     &           nxtwxmin,nxtwxsec)
             ifirst(1) = nxtwxyr
             ifirst(2) = istime
c
c            set bogus values for first call to read weather
             idir = 9
             ispeed = 9
             iclimate = 9
             call readwx
          endif         ! no particular start date
c
          if (irep .eq. 1) ipixids(6) = -1
c          print*,'Calling indicator to start'
          if (waveans .eq. 'Y') call indicator
c
       endif            ! wxtype is i
c
c
c     initialize imov year
c      before first call to readign
      imov(1) = ifirst(1)
      imov(2) = 0
c
c======================================================================
c
c  set up first fire start(s)
c   must ignite first starts after weather has been set above
c
c  in firemap,   0 = unburned
c               >0 = burning (how long burned; should never exceed 1)
c               <0 = burned  (how severely burned)
c
c      re-zero fire map from previous rep
       do j = 1, jcol
          do i = 1, irow
             mapfire(i,j) = 0
          enddo
       enddo
c
c
c  if multiple starts thru time, ignite first start and load next
       if (ignans .eq. 'Y') then
c
c          print*,'Calling readign'
          call readign
c
       else	! no starts thru time
c
c         random fire initiation
          if (startype .eq. 'R') then
             do i = 1, istarts
4                mstart(i,1) = int(getrandom()*jcol) + 1
                 mstart(i,2) = int(getrandom()*irow) + 1
                 if (maphab(mstart(i,1),mstart(i,2)) .lt. 1 .or.
     &            maphab(mstart(i,1),mstart(i,2)) .eq. 6) goto 4
c
c                fires initialized at random locations
                 call pushit (mstart(i,1), mstart(i,2))
             enddo
          endif
c
c         start a single fire at center of map
          if (startype .eq. 'C') then
c            if center is non-burnable,
c             look around for a flammable spot close by
             if (maphab(mstart(1,1),mstart(1,2)) .lt. 1 .or.
     &        maphab(mstart(1,1),mstart(1,2)) .eq. 6) then
                do j = -2, 2
                   jj = mstart(1,1) + j
                   do i = -2, 2
                     ii = mstart(1,2) + i
                     if (maphab(ii,jj) .ge. 1) call pushit (ii, jj)
                   enddo
                enddo
             else		! habitat at center is burnable, burn it
                call pushit (mstart(1,1), mstart(1,2))
             endif
          endif
c 
c         start fires at user-specified spots
c          if spot is non-burnable, alert user and skip this fire start
          if (startype .eq. 'F' .or. startype .eq. 'B') then
             do i = 1, istarts
                if (maphab(mstart(i,1), mstart(i,2)) .ge. 1 .and.
     &           maphab(mstart(i,1), mstart(i,2)) .ne. 6) then
                   call pushit (mstart(i,1), mstart(i,2))
                else
                   write(*, 778) mstart(i,1), mstart(i,2)
778                format(t15,'Habitat is not flammable at', 2i6/)
                endif
             enddo
          endif
c
       endif	! no starts thru time
c
       return
c======================================================================
c
c  read error traps
8888   write(*, 888) wxfile
888    format (t10,'Hit end of records in weather file ',a60)
       stop
c
9999   write(*, 999)
999    format (t10,'Bad data in first records of weather file!')
       stop
c
88888   write(*, 882) ignfile
882    format (t10,'Hit end of records in fire starts file ',a60)
       stop
c
99999   write(*, 992)
992    format (t10,'Bad data in first records of fire starts file!')
       stop
c
       end
c**********************************************************************
       subroutine readign
c
c       implicit real*4 (a-h,o-z)
       implicit none
       include 'parm.i'
       include 'common.i'
       integer*4 mmo, mday, mhr, mmin, msec, itime
       real*4 getrandom
       external getrandom
c
c      bump count and start the last ignitions
       istarts = istarts + 1
       call pushit (mstart(istarts,1), mstart(istarts,2))
       print *,'Starting fire ignition at ',mstart(istarts,2),
     &  ', ',mstart(istarts,1)
c
c      read next start & calculate interval to next ignition
777    read (13,1222,end=55555,err=99999) nxtstyr, nxtstmo, nxtstdy,
     &  nxtsthr, nxtstmin, nxtstsec, mstart(istarts+1,2),
     &  mstart(istarts+1,1)
c      changes to this format must be made to 1222 in beginfiresim also
1222      format(i4,5x,i2,5x,i2,5x,i2,1x,i2,1x,i2,5x,i4,5x,i4)
c
c      if both coordinates are 0, this start is random
       if (mstart(istarts+1,1) .eq. 0 .and.
     &  mstart(istarts+1,2) .eq. 0) then
          print *,'Random detected'
5         mstart(istarts+1,1) = int(getrandom()*jcol) + 1
          mstart(istarts+1,2) = int(getrandom()*irow) + 1
          if (maphab(mstart(istarts+1,1),mstart(istarts+1,2))
     &     .lt. 1 .or. maphab(mstart(istarts+1,1),mstart(istarts+1,2))
     &     .eq. 6) goto 5
       endif
c
       if (nxtstyr .gt. imov(1)) then	! no more starts this season
c
          iseos = 1	! set end-of-season flag
          print*,'Setting end-of-season flag'
c         next ignition is how many timesteps into that season?
          inextign = nint(timedate(nxtstyr, nxtstmo, nxtstdy, nxtsthr,
     &     nxtstmin, nxtstsec)/10.)
c
          itime = inextign*10
          call datetime(itime,nxtstyr,
     &        mmo,mday,mhr,mmin,msec)
             write(*, 778) mhr,mmin,msec,mmo,mday,nxtstyr
778          format (t10,"first start in next season will be "
     &        ,i2,":",i2,":",i2," on ",i2,"/",i2,"/",i4)
c
       else	! more starts this season
c
       inextign = nint((timedate(nxtstyr, nxtstmo, nxtstdy, nxtsthr,
     &  nxtstmin, nxtstsec) - timedate(lststyr, lststmo, lststdy,
     &  lststhr, lststmin, lststsec))/10.)
c
       endif
c
c      if interval to next equals 0, there is another start now
       if (inextign .eq. 0 .and. iseos .eq. 0) then	! more starts now
c
          print *,'More starts detected'
          istarts = istarts + 1
c
c         if both coordinates are 0, this start is random
          if (mstart(istarts,1) .eq. 0 .and.
     &     mstart(istarts,2) .eq. 0) then
             print *,'Random detected'
3            mstart(istarts,1) = int(getrandom()*jcol) + 1
             mstart(istarts,2) = int(getrandom()*irow) + 1
             if (maphab(mstart(istarts,1),mstart(istarts,2))
     &        .lt. 1 .or. maphab(mstart(istarts+1,1),
     &        mstart(istarts+1,2)) .eq. 6) goto 3
          endif
c
          call pushit (mstart(istarts,1), mstart(istarts,2))
          print *,'Starting additional fire ignition at ',
     &    mstart(istarts,2),', ',mstart(istarts,1)
          goto 777
       endif
c
c      start next interval now
       lststyr = nxtstyr
       lststmo = nxtstmo
       lststdy = nxtstdy
       lststhr = nxtsthr
       lststmin = nxtstmin
       lststsec = nxtstsec
c
c       print *,'inextign leaving readign is ',inextign
c
       return
c======================================================================
c
c  read error traps
c
c  no more fire starts in file, set interval to be very long
55555  inextign = 99999999
       return
c
99999   write(*, 992)
992    format (t10,'Bad data in first records of fire starts file!')
c
       stop
       end
c======================================================================
       subroutine firebrand (ib, jb)
c
c       implicit real*4 (a-h,o-z)   
       implicit none
       include 'parm.i'
       include 'common.i'
       integer*4 i, j, iwh, jwh, ib, jb, k, ifb
       real*4 xmean, xran
       real*4 getrandom
       external getrandom
c
c   ifb = the number of firebrands spawned from this habitat
c   get the number of firebrands to be thrown from this type of habitat
       ifb = ifbno(maphab(ib,jb))
c       print *,"throwing ",ifb," firebrands"
c
       do k = 1, ifb
c   obtain random displacement, and calculate new downwind location
c
          xmean = xfbmean(ispeed)
          call exponen (xmean, i, j) 
c
c          print *,xmean, i, j
          iwh = ib + i
          jwh = jb + j
c          print *, iwh, jwh
c
c   make sure new firebrand location is within map boundaries
          if (iwh .ge. 1 .and. iwh .le. irow .and. 
     &     jwh .ge. 1 .and. jwh .le. jcol) then
c
c  did firebrand land on a flammable spot?
             if (maphab(iwh,jwh) .gt. 0) then
c                 print *,k,"  found a flammable firebrand spot"
                 xran = getrandom()
c  try to start a new fire here
                 if (xran .le. ignition(iclimate, maphab(iwh,jwh)))
     & then
c                    print *,"starting firebrand"
                     call pushit (iwh, jwh)
                 endif
             endif
          else		! off edge of map
             if (stoptype .eq. 'E') then
c  if bottom row started initially, edge test applies only to top row
                if (startype .eq. 'B') then
                   if (iwh .lt. 1) then
                      write(*, 107) irep
107                   format ('Top edge reached by firebrand during
     & replication ', i6)
c
c  set edge detect flag
                      edgefb = 1
                      return
                   endif
                else
c                   print *, i, j, iwh, jwh
                   write(*, 108) jwh, iwh
108                format ('Edge reached by firebrand at coordinates ',
     &  i6, i6)
c
c  set edge detect flag
                   edgefb = 1
                   return
                endif
             endif
          endif		! still on map?
       enddo		!done throwing firebrands from this burning pixel
c
       return
       end
c**********************************************************************
c
       subroutine neighfire (ib, jb)
c
c       implicit real*4 (a-h,o-z)   
       implicit none
       include 'parm.i'
       include 'common.i'
       integer*4 nbrs, irel(maxsp), jrel(maxsp)
       integer*4 nj, in, ib, jn, jb, i
       real*4 prob, b, expo, slope, aran
       real*4 getrandom
       external getrandom
       data nbrs /8/
c
c clockwise examination of neighborhood, starting with north neighbor
c
       data (irel(i),i=1,8) /-1,-1, 0, 1, 1, 1, 0,-1/
       data (jrel(i),i=1,8) / 0, 1, 1, 1, 0,-1,-1,-1/
c  burning the neighborhood
c       print*, ib, jb
c                      write (37,553)
c553                   format ('ib  jb  mapfire(ib,jb)')
c                      write (37,554) ib, jb, mapfire(ib,jb)
c554                   format (i5,2x,i5,2x,i1)
c                      write (35,555)
c555                   format ('in   jn   aran   prob   b   exp')
       do nj = 1, nbrs
          in = ib + irel(nj)
          jn = jb + jrel(nj)
c       print*,'Considering spread to ', in, jn
c
c  test map range
          if (in .le. irow .and. jn .le. jcol .and. 
     &        in .ge. 1 .and. jn .ge. 1) then
c
c  determine if habitat is flammable
             if (maphab(in,jn) .gt. 0) then
c
c  evaluate current burn status here 
                if (mapfire(in,jn) .eq. 0) then
c
c  calculate probability of fire transfer
                    prob=firemat(iclimate,maphab(in,jn),maphab(ib,jb))
c  use 8-idir+nj for index pointer to proper place in windmat matrix
                    b=windmat(ispeed,8-idir+nj)
                    expo=1.-(1.- prob)**b
c              calculate local slope if there is an elevation map
                    if (elevans .eq. "y") then
                       slope=(mapelev(in,jn)-mapelev(ib,jb))/50.
                       if (slope .gt. slopemax) slope=slopemax
                       if (slope .lt. slopemax*(-1))
     &			slope=slopemax*(-1)
c              slope bias = slope factor ** (slope/slopemax)
                       slopeb = slopefct**(slope/slopemax)
c              apply slope effect
c                       print *, slopefct, slopemax, slope, slopeb
                       expo=1.-(1.- expo)**slopeb
c                       print *,expo
                    endif	! there is an elevation map
c
c              adjust final probability if it is a sub-cardinal direction
                    if (nj .eq. 2 .or. nj .eq. 4 .or.
     &               nj .eq. 6 .or. nj .eq. 8) expo=expo * 0.707106781
c
c                   write (35,556) in, jn, aran, prob, b, expo
556                 format (2i6,2x,g12.6,g12.6,g12.6,g12.6)
c
c  try to start a new fire
                    aran=getrandom()
                    if (aran .le. expo) then
c                      print *,'Pushing ',in,jn,' onto the stack'
                      call pushit (in, jn)
                   endif
                endif
             endif 
          else		! edge test 
             if (stoptype .eq. 'E') then
c if bottom row started initially, edge test applies only to top row
                if (startype .eq. 'B') then
                   if (in .lt. 1) then
                      write(*, 557) irep
557                   format ('Top edge reached by neighborhood during
     & replication ', i6)
c
c  set edge detect flag
                      edgenbr = 1
                   endif
                else
                   write(*, 558)
558                format ('Edge reached by neighborhood')
c
c  set edge detect flag
                   edgenbr = 1
                endif
             endif
          endif		! still on map?
c
       enddo  !for all neighbors of this burning site
c
       return
       end
c**********************************************************************
c
       subroutine pushit (i,j)
       implicit none
       include 'parm.i'
       include 'common.i'
       integer*4 i, j
c
c   check if burnable,
c   increment the total number of actively burning fires,
c   add this new fire to the vector,
c   and set the pixel to burning
c
c   6 pieces of information are kept about each burning cell:
c     x-coord, y-coord, kclock, lastsprd, burntime, and lastclk
c
c     lastsprd is countdown timer from the penultimate weather condx
c     burntime is total time in seconds this cell has been burning
c     lastclk is kclock after renormalizing at last weather change
c
       if (mapfire(i,j) .eq. 0) then
          ifcnt = ifcnt + 1
c
c        set stop flag if maxfires exceeded
          if (stoptype .eq. 'F' .and. ifcnt .gt. maxfires) 
     &      maxfiresend = 1
c
          iburning(ifcnt) = i
          jburning(ifcnt) = j
          kclock(ifcnt) = spreadmat(iclimate,maphab(i,j),ispeed)
          lastsprd(ifcnt) = spreadmat(iclimate,maphab(i,j),ispeed)
          burntime(ifcnt) = 0
          lastclk(ifcnt) = kclock(ifcnt)
c          print *, 'maphab(i,j) is ',maphab(i,j), kclock(ifcnt),
c     & lastsprd(ifcnt)
          if (spreadmat(iclimate,maphab(i,j),ispeed) .eq. 0) then
             print *,'ERROR - no weather for start of fire in pushit'
             print*,'i is ',i
             print*,'j is ',j
             print*,'maphab(i,j) is ',maphab(i,j)
             stop
          endif
c
          mapfire(i,j)  = 1
c        increment count of total pixels burned
          iburned = iburned + 1
c
c        set stop flag if maxburned exceeded
          if (stoptype .eq. 'B' .and. iburned .gt. maxburned)
     &      maxburnedend = 1
c
       endif
c
       return
       end
c**********************************************************************
c
       subroutine popit
       implicit none
       include 'parm.i'
       include 'common.i'
       integer*4 i, idummy
       real*4 sev, sevratio
c
c    perform stack cleanup - pop dead fires from stack
c
c  checks for dead fires (kclock = 0) from the bottom of the stack up
c    if last is zero, just decrements stack - if intermedate is zero,
c    moves last to fill intermediate zero's slot
c
c        lastsprd is rate for penultimate weather condx
c
c    burn severity is simulated as (heat released/time to burn cell)
c      burn severity is scaled to possible range for these parameters
c      burn severity gray scale is assigned logarithmically
c      for maximum visual differentiation 
c
c    get minimum clock (fastest old fire) for next timestep
c      while you're here
c
       inextclk = 99999999
       idummy = ifcnt
       do i = ifcnt,1,-1	! over all burning fires
c         in reverse order
          if (kclock(i) .lt. 0) then	! error check
             print *,"error - negative kclock encountered"
             print *, i, iburning(i), jburning(i), kclock(i)
             print *, burntime(i), lastsprd(i), lastclk(i)
             stop
          endif
c
          if (kclock(i) .eq. 0) then	! this fire dies
c            calc burn severity only if firemap written or viewed
             if (intout .eq. 'Y' .or. waveans .eq. 'Y') then
c               accumulate total burn time for this cell
                burntime(i)=burntime(i)+lastclk(i)
c
                sev=float(heat(maphab(iburning(i),jburning(i))))/
     &           float(burntime(i))
c
                if ( abs(sevmax - sevmin) .lt. 1.e-10) then
                   sevratio = 0.0
                else
                   sevratio=(sev-sevmin)/(sevmax-sevmin)
                endif
c
                mapfire(iburning(i),jburning(i)) = 
     &           -nint(101.-exp((1-sevratio)*log(101.)))
c
             else	! just set out fires negative
                mapfire(iburning(i),jburning(i)) = 
     &           -mapfire(iburning(i),jburning(i))
             endif	! severity is calculated
c
             if (kclock(i) .eq. idummy) then	! this one is last
                idummy = idummy - 1	! one fewer in stack
             else			! dying one is not last
c               move last over this dead fire
                iburning(i) = iburning(idummy)
                jburning(i) = jburning(idummy)
                kclock(i) = kclock(idummy)
                lastsprd(i) = lastsprd(idummy)
                lastclk(i) = lastclk(idummy)
                burntime(i) = burntime(idummy)
                idummy = idummy - 1
             endif			! this one is last
          else	! for fires that don't die, get minimum clock
             if(kclock(i) .lt. inextclk) inextclk = kclock(i)
          endif    !for fires that die
       enddo      !over all burning fires 
       ifcnt = idummy
c
       return
       end
c
c**********************************************************************
c
       subroutine exponen (xmean, i, j)
c
c ** exponential distribution
c
c       implicit real*4 (a-h,o-z)
       implicit none
       include 'parm.i'
       include 'common.i'
       integer*4 i, j
       real*4 r, xmean, angle, x, y, cac
       real*4 getrandom, rannorm
       external getrandom, rannorm

c       common/blkcnt/ ifbno(maxsp), ifcnt, idir,
c     & ispeed, iburned, ifage, ifile, spreadmat(3,maxsp,0:2)
c       common/blkpop/ ihab, ihomohab, scale, firemat(3,maxsp,maxsp),
c     & windmat(0:2,16), ignition(3,maxsp), xfbmean(0:maxsp)
c
c  generate relative movement on a square lattice
c   reference angle is from position 5 (= north)
c   proceeds counterclockwise to account for origin in upper left
c       r = - (xmean * log(abs(getrandom())))
23     cac = getrandom()
       if (cac .eq. 0.0) go to 23
       r = - (xmean * log(cac))
c
c  output to file for stats
       if (ispeed .eq. 0) then
          angle = int(getrandom() * 360.)
       else
          if (idir .ge. 2) then
             angle = (9-idir) * 45.
          else
             angle = (idir-1) * 45.
          endif
c
c  introduce turbulence by adding normal random deviate to angle
c          print*,'Angle deviation is ', (rannorm(iseed)*3)
          angle = angle + (rannorm(iseed)*3.0)
       endif
c
c       print *, r, 'angle = ', angle
c       write (13,100) r, angle
c100    format (2x,g12.6,2x,g12.6) 
       x = r * cos(angle * 3.1415926 / 180.0) 
       y = r * sin(angle * 3.1415926 / 180.0)
       i = nint(x * scale)
       j = nint(y * scale)
c       print *,"idir,r, angle, sind(angle),cosd(angle),x,y",idir,r,
c     & angle,sind(angle),cosd(angle),x,y,scale
c
       return
       end
c**********************************************************************
       subroutine stacksort(n,iarr,ibrr,icrr)
       implicit none
       integer*4 n, j, i, iarr, ibrr, icrr
       integer*4 a, b, c
       dimension iarr(n),ibrr(n),icrr(n)
c
c  pick out each element in turn
       do 12 j=2,n
         a=iarr(j)
         b=ibrr(j)
         c=icrr(j)
c
c  look for the place to insert it
         do 11 i=j-1,1,-1
           if(iarr(i).le.a)go to 10
           iarr(i+1)=iarr(i)
           ibrr(i+1)=ibrr(i)
           icrr(i+1)=icrr(i)
11       continue
         i=0
c
c  insert the number here
10       iarr(i+1)=a
         ibrr(i+1)=b
         icrr(i+1)=c
12     continue
       return
       end
c**********************************************************************
       subroutine pixmaperror(ierr)
c
c       implicit real*4 (a-h,o-z)
       implicit none
       integer*4 ierr
c
       if (ierr .eq. -1) then
          print *,"visualization tool out of memory"
       else if (ierr .eq. -2) then
          print *,"maximum number of visualization",
     & " windows exceeded"
       else if (ierr .eq. -3) then
          print *,"invalid data sent to visualization",
     & " tool"
       else if (ierr .eq. -4) then
          print *,"internal xpm routine error"
c       else
c          print *,"indeterminate visualization error"
       endif
c
       return
       end
c
c**********************************************************************
c
      subroutine readwx
c
c      implicit real*4 (a-h,o-z)
      implicit none
      include 'parm.i'
      include 'common.i'
c
c  this subroutine reads weather information from the filename specified
c   in input.f (weather.matrix by default)
c  it reads the current weather record, then flips ahead through records
c   looking for the next weather change, and calculates the time interval in
c   10-second timesteps until that weather change
c 
c      print *,'iclock is ',iclock,' and inextwx is ',inextwx
c      print *,'imov(1) is ',imov(1)
c
c  next weather becomes current weather
c  and print what changes
c
      if (ndir .ne. idir .and. ndir .ne. 0) then
         idir = ndir
         write(*, 3010) idir
3010     format (t15,'Wind source direction is now ',i1)
      endif
c
      if (nspeed .ne. ispeed) then
         ispeed = nspeed
         write(*, 3000) ispeed
3000     format (t15,'Wind speed class is now ',i2)
      endif
c
      if (nclimate .ne. iclimate) then
         iclimate = nclimate
         write(*, 3050) iclimate
3050     format (t15,'Fuel moisture class is now ',i2)
      endif
c
c      print*,'Calling indicator from readwx'
c      call indicator
c
c     read next weather record
 20   read (30,1000,end=8888,err=9999) nxtwxyr, nxtwxmo, nxtwxdy,
     &     nxtwxhr, nxtwxmin, nxtwxsec, nwd, nws, n10hr, n1000hr
c     format paired with one in beginfiresim and findwx
1000  format(i4,5x,i2,5x,i2,5x,i2,1x,i2,1x,i2,5x,a2,5x,i3,5x,
     & i2,5x,i2)
c
      if (nxtwxyr .gt. imov(1)) then   ! no more wx this season
         inextwx = 99999999	! don't come back here 'till next yr
         write(*, 652) imov(1)
652      format ('WARNING - constant weather for remainder of ',i6,
     &    ' season')
         return
      endif
c
c  class this weather
      call classwx(nwd,nws,n10hr,n1000hr,ndir,nspeed,nclimate)
c
c     re-read until first weather change
      if (ndir .eq. idir .and. nspeed .eq. ispeed .and.
     &  nclimate .eq. iclimate) then
      write(*, 997) nxtwxmo,nxtwxdy,nxtwxyr,nxtwxhr,nxtwxmin,nxtwxsec
997   format (t10,'Skipping weather record of same wx class at ',
     & i2,"/",i2,"/",i4," at ",i2,":",i2,":",i2)
         goto 20
      endif
c
c     calculate interval to next wx change in 10-sec timesteps
      inextwx = nint((timedate(nxtwxyr,nxtwxmo,nxtwxdy,nxtwxhr,
     & nxtwxmin,nxtwxsec) - ((imov(2)*10) + istime))/10.)
      print *,'inextwx in readwx is ',inextwx
c
      write(*, 998) nxtwxmo,nxtwxdy,nxtwxyr,nxtwxhr,nxtwxmin,nxtwxsec
998   format (t10,'Next weather change is ',i2,"/",i2,"/",i4," at ",
     & i2,":",i2,":",i2)
c
      return
c======================================================================
c
c error traps
8888  write(*, 888)
888   format ('WARNING - burning conditions now constant!')
c  set inextwx to be very large
      inextwx = 99999999
      return
c
9999  write(*, 999)
999   format (t10,'Bad data in weather file!')
c
      stop
      end
c**********************************************************************
       subroutine findwx(jtime)
c
c       implicit real*4 (a-h,o-z)
       implicit none
       integer*4 jtime, ntime
       include 'parm.i'
       include 'common.i'
c      
c  findwx is called 3 places - all from within movit.f
c   1) from beginfiresim - for first ignition
c   2) at eos - for first ign next season
c   3) if all fires out - for next ign this season
c
c      preserve weather from last-read record before overwriting
c       in case next is past time
       wd = nwd
       iws = nws
       i10hr = n10hr
       i1000hr = n1000hr
c
c      read next wx record
333    read (30,1000,end=8888,err=9999) nxtwxyr, nxtwxmo, nxtwxdy,
     &  nxtwxhr, nxtwxmin, nxtwxsec, nwd, nws, n10hr, n1000hr
1000   format(i4,5x,i2,5x,i2,5x,i2,1x,i2,1x,i2,5x,a2,5x,i3,5x,
     &  i2,5x,i2)
c       print *,'Findwx just read weather on ',nxtwxyr, nxtwxhr,
c     & nxtwxmin, nxtwxsec
c
c       skip ahead to right year if not
       if (nxtwxyr .lt. imov(1)) goto 333
c
c      are we past the first start?
       ntime = timedate(nxtwxyr,nxtwxmo,nxtwxdy,nxtwxhr,
     &  nxtwxmin,nxtwxsec)
c       print *,'ntime is ',ntime
c       print *,'jtime is ',jtime
       if (ntime .lt. jtime .and. imov(1) .eq. nxtwxyr) then
c      not past yet, reread
c
c         this wx becomes previous
          wd = nwd
          iws = nws
          i10hr = n10hr
          i1000hr = n1000hr
c          print *,'Skipping last weather record'
          goto 333
       endif	! just read is past time
c
c      warn if out of weather for this year
       if (nxtwxyr .gt. imov(1)) write(*, 202) imov(1)
202      format ('WARNING - constant weather for remainder of ',i6,
     &    ' season')
c
c        print *, nxtwxyr, nxtwxmo, nxtwxdy
c        print *, wd, iws, i10hr, i1000hr
c       set wx from previous record
       call classwx(wd,iws,i10hr,i1000hr,idir,ispeed,iclimate)
c
c       print this weather
       write(*, 211) idir, ispeed, iclimate
211    format(t10,'Fire start has wind from ',i1,
     &  ' at speed class ',i1,' with fuel moisture class ',i1)
c
c       set wx just read to next
       call classwx(nwd,nws,n10hr,n1000hr,ndir,nspeed,nclimate)
c
c       find the next weather change
c        does the record just read represent a wx change?
c        
221    if (ndir .eq. idir .and. nspeed .eq. ispeed .and.
     &  nclimate .eq. iclimate) then
          write(*, 997) nxtwxmo,nxtwxdy,nxtwxyr,nxtwxhr,nxtwxmin,
     &         nxtwxsec
997       format (t10,'Skipping weather record of same wx class at ',
     &     i2,"/",i2,"/",i4," at ",i2,":",i2,":",i2)
          read (30,1000,end=8888,err=9999) nxtwxyr, nxtwxmo, nxtwxdy,
     &      nxtwxhr, nxtwxmin, nxtwxsec, nwd, nws, n10hr, n1000hr
          call classwx(nwd,nws,n10hr,n1000hr,ndir,nspeed,nclimate)
          goto 221
       endif
c
       inextwx = nint((timedate(nxtwxyr,nxtwxmo,nxtwxdy,nxtwxhr,
     &  nxtwxmin,nxtwxsec) - jtime)/10.)
c
        print *,'inextwx leaving findwx is ', inextwx
       return
c======================================================================
c
c error traps
8888  write(*, 888)
888   format (t10,'Burning conditions now constant!')
c  set inextwx to be very large
      inextwx = 99999999
      return
c
9999  write(*, 999)
999   format (t10,'Bad data in weather file!')
c
      stop
      end
c======================================================================
      integer*4 function timedate(yr,mo,day,hr,min,sec)
c
c      implicit real*4 (a-h,o-z)
      implicit none
      integer*4 mo,day,hr,min,sec
      integer*4 yr,yrdays,numdays
c
c  given the calendar year and the month, day, and time
c   this routine returns the number of seconds since
c   the beginning of this year
c
c  
c  get days since beginning of this year
      yrdays = 0
      if (mo .eq. 2) then
         yrdays=31
      else if (mo .eq. 3) then
         yrdays=31+28
      else if (mo .eq. 4) then
         yrdays=31+28+31
      else if (mo .eq. 5) then
         yrdays=31+28+31+30
      else if (mo .eq. 6) then
         yrdays=31+28+31+30+31
      else if (mo .eq. 7) then
         yrdays=31+28+31+30+31+30
      else if (mo .eq. 8) then
         yrdays=31+28+31+30+31+30+31
      else if (mo .eq. 9) then
         yrdays=31+28+31+30+31+30+31+31
      else if (mo .eq. 10) then
         yrdays=31+28+31+30+31+30+31+31+30
      else if (mo .eq. 11) then
         yrdays=31+28+31+30+31+30+31+31+30+31
      else if (mo .eq. 12) then
         yrdays=31+28+31+30+31+30+31+31+30+31+30
      endif
c
      if (mod(yr,4) .eq. 0 .and. mo .gt. 2) yrdays=yrdays+1
c
      numdays = yrdays+day
      timedate = (numdays*86400)+(hr*3600)+(min*60)+sec
c      print *, 'from timedate: yr, mo, day, hr, min, sec'
c      print *, yr, mo, day, hr, min, sec
c      print *, yrdays, numdays, timedate
c
      return
      end
c======================================================================
       subroutine datetime(itime,yr,mo,day,hr,min,sec)
c
c  given year and number of seconds since that year,
c   this routine returns the month, day, and time
c
c       implicit real*4 (a-h,o-z)
       implicit none
       integer*4 mo,day,hr,min,sec
       integer*4 yr,irem
       integer*4 itime
c
c  calculate remaining seconds in current year
       if (mod(yr,4) .eq. 0) then	! if its a leap year
          if (itime .ge. (31+28)*60*60*24) then		! past feb. 28
             if (itime .le. (31+29)*60*60*24) then	! before feb. 29
c  if this is a leap year and it's feb 29, calculate irem and skip
                mo = 2
                day = 29
                irem = itime - ((31+28)*60*60*24)
                goto 444
             endif
c  subtract one days' seconds if this is a leap year
c   and we're past feb. 29
             itime=itime-(60*60*24)
          endif
       endif
c
c
       if (itime .ge. (31+28+31+30+31+30+31+31+30+31+30+
     & 31)*60*60*24) then
          print *,"error - itime greater than 1 year"
          stop
       else if (itime .gt. (31+28+31+30+31+30+31+31+30+31+30)*
     & 60*60*24) then
          mo = 12
          irem = itime - ((31+28+31+30+31+30+31+31+30+31+30)*60*60*24)
       else if (itime .ge. (31+28+31+30+31+30+31+31+30+31)*60*
     & 60*24) then
          mo = 11
          irem = itime - ((31+28+31+30+31+30+31+31+30+31)*60*60*24)
       else if (itime .ge. (31+28+31+30+31+30+31+31+30)*60*60*
     & 24) then
          mo = 10
          irem = itime - ((31+28+31+30+31+30+31+31+30)*60*60*24)
       else if (itime .ge. (31+28+31+30+31+30+31+31)*60*60*24)
     &  then
          mo = 9
          irem = itime - ((31+28+31+30+31+30+31+31)*60*60*24)
       else if (itime .ge. (31+28+31+30+31+30+31)*60*60*24) then
          mo = 8
          irem = itime - ((31+28+31+30+31+30+31)*60*60*24)
       else if (itime .ge. (31+28+31+30+31+30)*60*60*24) then
          mo = 7
          irem = itime - ((31+28+31+30+31+30)*60*60*24)
       else if (itime .ge. (31+28+31+30+31)*60*60*24) then
          mo = 6
          irem = itime - ((31+28+31+30+31)*60*60*24)
       else if (itime .ge. (31+28+31+30)*60*60*24) then
          mo = 5
          irem = itime - ((31+28+31+30)*60*60*24)
       else if (itime .ge. (31+28+31)*60*60*24) then
          mo = 4
          irem = itime - ((31+28+31)*60*60*24)
       else if (itime .ge. (31+28)*60*60*24) then
          mo = 3
          irem = itime - ((31+28)*60*60*24)
       else if (itime .ge. (31*60*60*24)) then
          mo = 2
          irem = itime - (31*60*60*24)
       else
          mo = 1
          irem = itime
       endif
c
c
       day = irem/(60*60*24)
444    irem = irem - (day*60*60*24)
c
       hr = irem/(60*60)
       irem = irem - (hr*60*60)
c
       min = irem/60
c
       sec = irem - (min*60)
c
       return
       end
c======================================================================
       subroutine classwx(wd,ws,i10,i1000,id,is,ic)
c     implicit real*4 (a-h,o-z)
       implicit none
       integer*4 ws,i10,i1000,is,id,ic,imax
c       integer*4 i10c,i1000c
       character*2 wd
c
c     class wind speed
       is = 2
       if (ws .le. 12) is = 1
       if (ws .le. 5) is = 0
c
c       is = 2
c       if (ws .le. 35) is = 1
c       if (ws .lt. 5) is = 0
c
c
c     class fuel moisture
c      use the wetter of 10hr and 1000hr to class
       if (i10 .gt. i1000) then
          imax = i10
       else
          imax = i1000
       endif
c
       ic = 3
       if (imax .le. 16) ic = 2
       if (imax .lt. 12) ic = 1
c       print *, i10c, i1000c, ic
c
cc     class 10 hr fuel moisture
c         i10c = 3
c         if (i10 .le. 16) i10c = 2
c         if (i10 .lt. 12) i10c = 1
cc
cc     class 1000 hr fuel moisture
c         i1000c = 3
c         if (i1000 .le. 16) i1000c = 2
c         if (i1000 .lt. 12) i1000c = 1
cc
cc     if getting wetter, go to wetter class than current 1000 hr class
c         if (i10c .gt. i1000c) then
c            ic = i1000c + 1
cc     if getting drier, go to drier class than 1000 hr class
c         else if (i10c .lt. i1000c) then
c            ic = i1000c - 1
c         else
c            ic = i1000c
c         endif
cc         print *, i10c, i1000c, ic
c
c     class wind direction
       id = 99
       if (wd .eq. 'n' .or. wd .eq. 'N') id = 1
       if (wd .eq. 'ne' .or. wd .eq. 'NE') id = 2
       if (wd .eq. 'e' .or. wd .eq. 'E') id = 3
       if (wd .eq. 'se' .or. wd .eq. 'SE') id = 4
       if (wd .eq. 's' .or. wd .eq. 'S') id = 5
       if (wd .eq. 'sw' .or. wd .eq. 'SW') id = 6
       if (wd .eq. 'w' .or. wd .eq. 'W') id = 7
       if (wd .eq. 'nw' .or. wd .eq. 'NW') id = 8
       if (wd .eq. '0') id = 0
       if (id .eq. 99) then
          print *,'Error in wind direction!  wd is ' , wd,'!'
          stop
       endif
c
       return
       end
c======================================================================
       subroutine elapsed
c       implicit real*4 (a-h,o-z)
       implicit none
       include 'parm.i'
       include 'common.i'
       integer*4 isecd, imonths, iweeks, idays, ihrs, imins, isecs, iyrd
c
c  calculates total elapsed time across seasons
c   from difference between imov and ifirst arrays
c
c       print*,'imov(1) is ',imov(1)
c       print*,'ifirst(1) is ',ifirst(1)
       iyrd = imov(1) - ifirst(1)
c
       if ((imov(2)*10) .lt. ifirst(2)) then
          isecd = ((60*60*24*365)-ifirst(2))+(imov(2)*10)
          iyrd = iyrd - 1
       else	! (imov(2)*10) .ge. ifirst(2)
          isecd = (imov(2)*10)-ifirst(2)
       endif
c
c      add in # secs in leap year days that have passed
       isecd=isecd+(int(float(iyrd)/4.)*(60*60*24))
c
c     error trap
       if (isecd .ge. (60*60*24*365))then
          print*,'Elapsed time exceeds 1 year'
          return
       endif
c
       imonths = isecd/2419200
       iweeks = (isecd-(imonths*2419200))/604800
       idays = (isecd-(iweeks*604800)-(imonths*2419200))/86400
       ihrs = (isecd-(idays*86400)-(iweeks*604800)-
     &  (imonths*2419200))/3600
       imins = (isecd-(ihrs*3600)-(idays*86400)-(iweeks*604800)-
     &  (imonths*2419200))/60
       isecs = (isecd-(imins*60)-(ihrs*3600)-(idays*86400)-
     &  (iweeks*604800)-(imonths*2419200))
c
c       print*,'isecd is ',isecd
c       print*,'Elapsed in date form is ',imonths, iweeks, idays, ihrs,
c     &  imins, isecs
c
       if (isecd .lt. 60) then
          write(*, 99991) iyrd, isecs
99991     format (i4,' years ',i2,' secs have been simulated')
       else if (isecd .lt. 3600) then
          write(*, 99992) iyrd, imins, isecs
99992     format (i4,' years ',i2,' mins ',i2,' secs have been',
     &     ' simulated')
       else if (isecd .lt. 86400) then
          write(*, 99993) iyrd, ihrs, imins, isecs
99993     format (i4,' years ',i2,' hrs ',
     &     i2,' mins ',i2,' secs have been simulated')
       else if (isecd .lt. 604800) then
          write(*, 99994) iyrd, idays, ihrs, imins, isecs
99994     format (i4,' years ',i1,' days ',i2,' hrs ',
     &     i2,' mins ',i2,' secs have been simulated')
       else if (isecd .lt. 2419200) then
          write(*, 99995) iyrd, iweeks, idays, ihrs, imins, isecs
99995     format (i4,' years ',i1,' wks ',i1,' days ',i2,' hrs ',
     &     i2,' mins ',i2,' secs have been simulated')
       else
          write(*, 99996) iyrd, imonths, iweeks, idays, ihrs,
     &     imins, isecs
99996     format (i4,' years ',i6,' months ',i1,' wks ',i1,' days ',
     &     i2,' hrs ',i2,' mins ',i2,' secs have been simulated')
       endif
c
         return
         end
c======================================================================
