c  landstat.f
       subroutine landstat
c
c       implicit real*4 (a-h,o-z)
       implicit none
       include 'parm.i'
       include 'common.i'
       integer*4 typecell, i, j, k, ibnabl, iunb, ibnd, ibdubd, iwinbd
       integer*4 iwinubd, nperim
       integer*4 ntotedg, nhoriz, nvert, here, right, below
       real*4 h1, h3hor, h3ver, h1max, d1, d
       real*4 d3hor, d3ver, h3, c, temp
c, paratio
c
c  ihfreq and ivfreq are number of horiz and vert i,j adjacencies
c  hprob and vprob are probabilities from these frequencies
c  aprob is the fraction of the landscape occupied by each type
c
c      zero all arrays
       do i=0,ihab+3
          ifreq(i) = 0
          aprob(i) = 0.
          ihedges(i) = 0
          ivedges(i) = 0
          do j=0,ihab+3
             ihfreq(i,j) = 0
             hprob(i,j) = 0.
             ivfreq(i,j) = 0
             vprob(i,j) = 0.
          enddo
       enddo
c
c**********************************************************
c  count total number of cells for each fuel type
c  calculate probability of occurrence of each fuel type
c
c  count nearest neighbor adjacencies horizontally and vertically
c   and store in ihfreq and ivfreq
c   and calculate probabilities in hprob and vprob
c
c  count vertical and horizontal edges between burnable types
c
c
c  type first cell
       here = typecell(1,1)
c
       do i=1, irow-1
          do j=1, jcol-1
c
c  type cell to right
             right = typecell(i,j+1)
c
c  type cell below
             below = typecell(i+1,j)
c
c
             ifreq(here) = ifreq(here) + 1
             if (here .ne. 0) then
                if (right .ne. 0) then
                   ihfreq(here,right) = ihfreq(here,right) + 1
                   ihedges(here) = ihedges(here) + 1
                endif
                if (below .ne. 0) then
                   ivfreq(here,below) = ivfreq(here,below) + 1
                   ivedges(here) = ivedges(here) + 1
                endif
c                if (right .ne. 0 .and. below .ne. 0)
c     &           ipijk(below,right,here) = ipijk(below,right,here) + 1
             endif
c
c            next here becomes last right
             here = right
          enddo
c
c         do last here and below in this row
          below=typecell(i+1,j)
          ifreq(here) = ifreq(here) + 1
          if (here .ne. 0) then
             if (below .ne. 0) then
                ivfreq(here,below) = ivfreq(here,below) + 1
                ivedges(here) = ivedges(here) + 1
             endif
          endif
       enddo
c
c
c  do here and right in last row
       here = typecell(irow,j)
c
       do j=1, jcol - 1
          right = typecell(irow,j+1)
          ifreq(here) = ifreq(here) + 1
          if (here .ne. 0) then
             if (right .ne. 0) then
                ihfreq(here,right) = ihfreq(here,right) + 1
                ihedges(here) = ihedges(here) + 1
             endif
          endif
c
c         next here becomes last right
          here = right
       enddo
c
c  count last cell
       ifreq(here) = ifreq(here) + 1
c
c**********************************************************
c
c  print column headings
       write(*, 101)
101    format (/' Cell Totals:'/)
c
       write(*, 103)
103    format ('    Not                                      N',
     &  'ot  Burned  Burned Burning')
       write(*, 105)
105    format (t4,' Flam     LP0     LP1     LP2     LP3  For',
     &  'est      SR     NSR     Now'/)
c
c
c**********************************************************
c
c  print total numbers and total
       write(*, 107) (ifreq(i),i=0,ihab+3)
107    format (20(1x,i7))
c
       write(*, 111)
111    format (/' Cell Probabilities:'/)
c
c  print column headings
       write(*, 113)
113    format ('    Not                                      N',
     &  'ot  Burned  Burned Burning')
       write(*, 115)
115    format (t4,' Flam     LP0     LP1     LP2     LP3  For',
     &  'est      SR     NSR     Now'/)
c
c  print total probabilities
       write(*, 117) (float(ifreq(i))/float(irow*jcol),i=0,ihab+3)
117    format (20(1x,f7.2))
c
       k = 0
       do i=0,ihab+3
          k=k+ifreq(i)
       enddo
c
       write(*, 118) k
118    format (/t10,'Total Cells =', i10//)
c
c**********************************************************
c
c  sum total burnable cells in fuelscape
       ibnabl=0
       do i=1,ihab+3
          ibnabl=ibnabl+ifreq(i)
       enddo
c
c  calculate probability of occurrence,
c   horizontal probability of occurrence,
c   and vertical probability of occurrence of each fuel type
c   and store in aprob, hprob, and vprob arrays
       do i=1,ihab+3
          aprob(i)=float(ifreq(i))/float(ibnabl)
          do j=1,ihab+3
             if (ihedges(i) .ne. 0) then
                hprob(i,j)=float(ihfreq(i,j))/float(ihedges(i))
             else
                hprob(i,j) = 0
             endif
             if (ivedges(i) .ne. 0) then
                vprob(i,j)=float(ivfreq(i,j))/float(ivedges(i))
             else
                vprob(i,j) = 0
             endif
          enddo
       enddo
c
c  print burnable probabilities
       write(*, 129) (aprob(i),i=1,ihab+3)
129    format (8x,20(1x,f7.2))
c
       write(*, 131) ibnabl
131    format (/t10,'Total Burnable Cells =', i10//)
c
c**********************************************************
c
c  sum total unburned cells in fuelscape
       iunb=0
       do i=1,ihab
          iunb=iunb+ifreq(i)
       enddo
c
c  print unburned probabilities
       write(*, 149) (float(ifreq(i))/float(iunb),i=1,ihab)
149    format (8x,100(1x,f7.2))
c149    format (8x,<ihab>(1x,f7.2))
c
       write(*, 151) iunb
151    format (/t10,'Total Unburned Cells =', i10//)
c
c**********************************************************
c
c  sum total burned cells in fuelscape
       ibnd=0
       do i=ihab+1,ihab+3
          ibnd=ibnd+ifreq(i)
       enddo
c
c  print burned probabilities
       write(*, 159) (float(ifreq(i))/float(ibnd),i=ihab+1,ihab+3)
159    format (6(8x),3(1x,f7.2))
c159    format (<ihab+1>(8x),3(1x,f7.2))
c
       write(*, 161) ibnd
161    format (/t10,'Total Burned Cells =', i10//)
c
c**********************************************************
c
c  calculate indices
c
c   h1 (diversity)
c   d1 (dominance)
c   h3 and d3 (contagion) in horiz and vert directions
c  indices are also normalized for # of fuel types and
c   scaled from 0 to 1.
      h1=0.
      h3hor=0.
      h3ver=0.
c
      do j=1,ihab+3
         if (aprob(j) .ne. 0.) h1=h1-aprob(j)*log(aprob(j))
         do i=1,ihab+3
            if (hprob(i,j) .ne. 0.) 
     &       h3hor=h3hor-hprob(i,j)*log(hprob(i,j))
            if (vprob(i,j) .ne. 0.)
     &       h3ver=h3ver-vprob(i,j)*log(vprob(i,j))
         enddo
      enddo
c
      h1max = log(float(ihab+3))
      d1    = h1max-h1
      d     = 1-(h1/h1max)
      d3hor = (ihab+3)*h1max - h3hor
      d3ver = (ihab+3)*h1max - h3ver
      h3    = (h3hor+h3ver)*0.5
      c     = 1 - (h3/((ihab+3)*h1max))
c
      write(*, 171)
171   format(' Information Theoretic Indices:'/)
      write(*, 173)
173   format(' Diversity  Dominance  Contagion-Hor  Contagion-Ver')
      write(*, 175) h1, d1, d3hor, d3ver
175   format(1x,f9.3,2x,f9.3,f11.3,5x,f11.3)
      write(*, 177) d, c
177   format(/1x,'Scaled: Dominance= ',f6.3,'   Contagion= ',f6.3///)
c
c
c      sum = 0.0
cc
cc  accumulate log products
c      do i=1,ihab
c         do j=1,ihab
c            do k=1,ihab
c               if (ipijk(i,j,k) .ne. 0) then
c                  logp = log(float(ipijk(i,j,k)))
c                  sum = sum + ipijk(i,j,k)*logp
c               endif
c            enddo
c         enddo
c      enddo
cc
cc  calculate d3 and h3 by alternate methods
cc
c      d3 = (2.*float(iunb)*log(float(iunb)))/sum
c      h3 = -sum
c      write(*, 179) d3, h3
c179   format(/1x,'d3=',f11.3,'  h3=-sum pijk*ln(pijk)=',f18.3///)
c
c---------------------------------------------------------
c  indices for unburned
      h1=0.
      h3hor=0.
      h3ver=0.
c
      do j=1,ihab
         temp = float(ifreq(i))/float(iunb)
         if (temp .ne. 0) h1=h1-temp*log(temp)
         do i=1,ihab
            if (hprob(i,j) .ne. 0.)
     &       h3hor=h3hor-hprob(i,j)*log(hprob(i,j))
            if (vprob(i,j) .ne. 0.)
     &       h3ver=h3ver-vprob(i,j)*log(vprob(i,j))
         enddo
      enddo
c
      h1max = log(float(ihab))
      d1    = h1max-h1
      d     = 1-(h1/h1max)
      d3hor = ihab*h1max - h3hor
      d3ver = ihab*h1max - h3ver
      h3    = (h3hor+h3ver)*0.5
      c     = 1 - (h3/(ihab*h1max))
c
      write(*, 271)
271   format(//' Indices for Unburned only:'/)
      write(*, 273)
273   format(' Diversity  Dominance  Contagion-Hor  Contagion-Ver')
      write(*, 275) h1, d1, d3hor, d3ver
275   format(1x,f9.3,2x,f9.3,f11.3,5x,f11.3)
      write(*, 277) d, c
277   format(/1x,'Scaled: Dominance= ',f6.3,'   Contagion= ',f6.3///)
c
c---------------------------------------------------------
c  indices for burned
      h1=0.
      h3hor=0.
      h3ver=0.
c
      do j=ihab+1,ihab+3
         temp = float(ifreq(i))/float(iunb)
         if (temp .ne. 0) h1=h1-temp*log(temp)
         do i=ihab+1,ihab+3
            if (hprob(i,j) .ne. 0.)
     &       h3hor=h3hor-hprob(i,j)*log(hprob(i,j))
            if (vprob(i,j) .ne. 0.)
     &       h3ver=h3ver-vprob(i,j)*log(vprob(i,j))
         enddo
      enddo
c
      h1max = log(float(ihab))
      d1    = h1max-h1
      d     = 1-(h1/h1max)
      d3hor = ihab*h1max - h3hor
      d3ver = ihab*h1max - h3ver
      h3    = (h3hor+h3ver)*0.5
      c     = 1 - (h3/(ihab*h1max))
c
      write(*, 371)
371   format(//' Indices for Burned only:'/)
      write(*, 373)
373   format(' Diversity  Dominance  Contagion-Hor  Contagion-Ver')
      write(*, 375) h1, d1, d3hor, d3ver
375   format(1x,f9.3,2x,f9.3,f11.3,5x,f11.3)
      write(*, 377) d, c
377   format(/1x,'Scaled: Dominance= ',f6.3,'   Contagion= ',f6.3///)
c
c**********************************************************
c
c  output nearest neighbor frequencies and probabilities
c
c
       write(*, 180)
180    format ('    Not                                      N',
     &  'ot  Burned  Burned Burning')
       write(*, 181)
181    format (t4,' Flam     LP0     LP1     LP2     LP3  For',
     &  'est      SR     NSR     Now'/)
c
       write(*, 182)
182    format (' Horizontal Transition Frequencies')
       do i=1,ihab+3
          write(*, 185) (ihfreq(i,j),j=1,ihab+3)
c185       format (8x,<ihab+3>(1x,i7))
185       format (8x,100(1x,i7))
       enddo
c
       write(*, 186) (ihedges(i), i=1,ihab+3)
c186    format (/'Rowtot =',<ihab+3>(1x,i7))
186    format (/'Rowtot =',100(1x,i7))
c
       write(*, 187)
187    format (/' Horizontal Transition Probabilities')
       do i=1,ihab+3
          if (ihedges(i) .ne. 0) then
             write(*,189) (float(ihfreq(i,j))/
     &        float(ihedges(i)),j=1,ihab+3)
          else
             write(*, 189) 0.,0.,0.,0.,0.,0.,0.,0.
          endif
c189       format (8x,<ihab+3>(1x,f7.2))
189       format (8x,100(1x,f7.2))
       enddo
c
c
c
       write(*, 190)
190    format (//'    Not                                      N',
     &  'ot  Burned  Burned Burning')
       write(*, 191)
191    format (t4,' Flam     LP0     LP1     LP2     LP3  For',
     &  'est      SR     NSR     Now'/)
c
       write(*, 192)
192    format (' Vertical Transition Frequencies')
       do i=1,ihab+3
          write(*, 195) (ivfreq(i,j),j=1,ihab+3)
c195       format (8x,<ihab+3>(1x,i7))
195       format (8x,100(1x,i7))
       enddo
c
       write(*, 196) (ivedges(i), i=1,ihab+3)
c196    format (/'Rowtot =',<ihab+3>(1x,i7))
196    format (/'Rowtot =',100(1x,i7))

c
       write(*, 197)
197    format (/' Vertical Transition Probabilities')
       do i=1,ihab+3
          if (ivedges(i) .ne. 0) then
             write(*, 199) (float(ivfreq(i,j))/
     &        float(ivedges(i)),j=1,ihab+3)
         else
             write(*, 199) 0.,0.,0.,0.,0.,0.,0.,0.
          endif
c199       format (8x,<ihab+3>(1x,f7.2))
199       format (8x,100(1x,f7.2))
       enddo
c
c**********************************************************
c
c  sum amount of edge
c
       write(*, 205)
205    format(//' Amount of Edge between fuel and burn types:'/)
c
       ntotedg=0
       nhoriz=0
       nvert=0
c
       do i=1,ihab+3
          do j=i+1,ihab+3
             write(*, 207) i, j, ihfreq(i,j) + ihfreq(j,i) +
     &        ivfreq(i,j) + ivfreq(j,i)
             ntotedg = ntotedg + ihfreq(i,j) + ihfreq(j,i) +
     &        ivfreq(i,j) + ivfreq(j,i)
             nhoriz = nhoriz + ihfreq(i,j) + ihfreq(j,i)
             nvert = nvert + ivfreq(i,j) + ivfreq(j,i)
207          format(7x,'Types',i3,' and',i3,'  Edge =',i7)
          enddo
       enddo
c
       write(*, 220) ntotedg
220    format(/t10,'Total Edge = ',i10)
c
       write(*, 221) nhoriz
221    format(/t10,'Total Horizontal Edge = ',i10)
c
       write(*, 222) nvert
222    format(t10,'Total Vertical Edge = ',i10,/)
c
c
       ibdubd=0
       do i=ihab+3,ihab+1,-1
          do j=1,ihab
c             print *,'Doing edges ',i,' and',j
             ibdubd = ibdubd + ihfreq(i,j) + ihfreq(j,i) +
     &        ivfreq(i,j) + ivfreq(j,i)
          enddo
       enddo
c
       write(*, 223) ibdubd
223    format(/t10,'Edge between Burned and Unburned = ',i10,/)
c
c
       iwinbd=0
       do i=ihab+3,ihab+1,-1
          do j=i-1,ihab+1,-1
c             print *,'Doing edges ',i,' and',j
             iwinbd = iwinbd + ihfreq(i,j) + ihfreq(j,i) +
     &        ivfreq(i,j) + ivfreq(j,i)
          enddo
       enddo
c
       write(*, 225) iwinbd
225    format(t10,'Edge within Burned = ',i10,/)
c
c
       iwinubd=0
       do i=1,ihab
          do j=i+1,ihab
c             print *,'Doing edges ',i,' and',j
             iwinubd = iwinubd + ihfreq(i,j) + ihfreq(j,i) +
     &        ivfreq(i,j) + ivfreq(j,i)
          enddo
       enddo
c
       write(*, 227) iwinubd
227    format(t10,'Edge within Unburned = ',i10,//)
c
c
c
       do i=1,ihab+3
          nperim=0
c          paratio=0
          do j=1,ihab+3
             if (j .ne. i) nperim = nperim + 
     &        ihfreq(i,j) + ihfreq(j,i) +
     &        ivfreq(i,j) + ivfreq(j,i)
          enddo
          write(*, 229) i, nperim
229       format('Total Perimeter for Type ', i3, ' is ', i10)
          if (ifreq(i) .gt. 0) then
             write(*, 231) float(nperim)/float(ifreq(i))
          else
             write(*, 231) float(ifreq(i))
          endif
231       format(t8,'Perimeter/Area Ratio is ', f7.2/)
       enddo
c
c**********************************************************
c
       return
       end
c
c**********************************************************
c
       integer*4 function typecell(i,j)
c
c       implicit real*4 (a-h,o-z)
       implicit none
       include 'parm.i'
       include 'common.i'
       integer*4 i, j
c
       if (mapfire(i,j) .lt. 0) then	! cell has burned
          if (-mapfire(i,j) .gt. srthresh) then
             typecell = ihab + 1      ! stand-replacing
          else
             typecell = ihab + 2      ! not stand-replacing
          endif
       else if (mapfire(i,j) .eq. 0) then	! unburned
          typecell = maphab(i,j)
c         recode water to category 0
          if (typecell .eq. 6) typecell = 0
       else	! burning now
          typecell = ihab + 3
       endif
c
       return
       end
c**********************************************************
