c   input.f  -- for fire simulations  1/13/92
       subroutine input 
c       implicit real*4 (a-h,o-z)   
       implicit none
       include 'parm.i'
       include 'common.i'
c
c       character*24 dates
       external time
       integer*4 time
       integer*4 il, ijk, iyr, imo, iday, ihr, imin, isec, i, j, k, ii
       real*4 pmap
c
       write(*, 1000)
1000   format (///,'Welcome to') 
       write(*, 1002)
1002   format ('-----------------------------------------',
     & '----------------------------------')
       write(*, 1004)
1004   format ('           ____    _   _     ___   _   __   ___')
       write(*, 1006)
1006   format ('           /      /|  /|     /  )   \\  /    /  )')
       write(*, 1008)
1008   format ('          /--    / | / |    /--<     \\/    /--<')
       write(*, 1010)
1010   format ('        _/___  _/  |/  |_  /___/    _/   _/    \\_',/)
       write(*, 1012)
1012   format ('-----------------------------------------',
     & '----------------------------------')
       write(*, 1014)
1014   format (' An _E_cological _M_odel for _B_urning',
     & ' _Y_ellowstone _R_egions',///)
c
c  write execution script for next run
       open (9, file='fire.scr',status='unknown')
c
c       call fdate (dates)
c       write(*, 1015) dates
1015   format (//t10,'EMBYR Fire model',t50,a24//)
c======================================================================
c
c enter random number seed
       write(*, 96)
96     format (t10,'Do you want to enter a random number seed <Y>',
     &  /t12,' or use the system clock? [clock]')
       read(*, 97) ans
       if (ans .eq. 'Y' .or. ans .eq. 'y') then
          write (9,97) ans
97        format (a1,t20,"(Enter seed or clock?)")
          write(*, 100)
100       format (t10,'Enter random number seed ')
          read *, iseed
          write (9,101) iseed
101       format (i12,t20,"(Random number seed)")
       else
21        iseed = time( )
          if (iseed .eq. 0) then
             print *, "iseed was zero."
             go to 21
          endif
          write(*, 98)
98        format (t15,'Random number seed from system clock.'/)
          write (9,99) ans, iseed
99        format (a1,t20,"(Random seed from clock = ",i12,")")
       endif
c
       write(*, 1017) iseed
1017   format (t15,'Random number seed = ',i12/)
c
c       print *, 'calling initrandom'
       call initrandom(iseed)
c======================================================================
c
c   maptype is the type of habitat map to be used
5      write(*, 110)
110    format (t10,'Enter map type; <U>niform, <R>andom, <G>radient, ',
     &  'or <I>nput ')
       read(*, 112) maptype
112    format (a1)
c
          if (maptype .eq. 'u') maptype = 'U'
          if (maptype .eq. 'r') maptype = 'R'
          if (maptype .eq. 'c') maptype = 'C'
          if (maptype .eq. 'i') maptype = 'I'
          if (maptype .eq. 'g') maptype = 'G'
c
       write(*, 1020) maptype
1020   format (t15,'Map type is ',a1/)
       write (9,1021) maptype
1021   format (a1,t20,"(Maptype)")
c======================================================================
c      
       if (maptype .ne. 'R' .and. maptype .ne. 'C' 
     & .and. maptype .ne. 'I' .and. maptype .ne. 'U'
     & .and. maptype .ne. 'G') then
            goto 5
       endif
c
c  enter parameters for random or uniform map
       if (maptype .eq. 'R' .or. maptype .eq. 'U') then       
15        write(*, 120)
120       format (t10,'Enter the probability [0..1] ')
          read *, p
          if (p .lt. 0.0 .or. p .gt. 1.0) goto 15
          write(*, 1050) p
1050      format (t15,'P = ',f12.6/)
          write (9,1051) p
1051      format (f12.6,t20,"(Probability of habitat type)")
       endif
c======================================================================
c
c  enter number of habitat types
       write(*, 130)
130    format (t10,'The standard cover types are as follows:')
       write(*, 131)
131    format (t15,'Number',20x,'Type'/)
       write(*, 132)
132    format (t17,'0',12x,'not flammable')
       write(*, 133)
133    format (t17,'1',12x,'LP0 - lodgepole complex 0 to 40 yrs old')
       write(*, 134)
134    format (t17,'2',12x,'LP1 - lodgepole complex 50 to 150 yrs old')
       write(*, 135)
135    format (t17,'3',12x,'LP2 - lodgepole complex 150 to 300 yrs old')
       write(*, 136)
136    format (t17,'4',12x,'LP3 - lodgepole complex > 300 yrs old')
       write(*, 137)
137    format (t17,'5',12x,'NF - not forested'/)
20     write(*, 150)
150    format (t10,'Do you want the 5 standard cover types? [y]')
       read(*, 160) ans
160    format (a1)
       write (9,161) ans
161    format (a1,t20,"(5 standard cover types?)")
       if (ans .ne. 'N' .and. ans .ne. 'n') then
          ans = 'Y'
          ihab=5
          write(*, 1080) ans
1080      format (t15,'Use the five standard cover types: ',a1/)
       endif
       if (ans .eq. 'N' .or. ans .eq. 'n') then
          write(*, 180)
180       format (t10,'Enter the number of cover types')
          read *, ihab
          write (9,1999) ihab
1999      format (i6,t20,"(Number of cover types)")
       endif
       write(*, 2000) ihab
2000   format (t15,'cover types = ',i6/)
c======================================================================
c
       if (maptype .eq. 'U' .or. maptype .eq. 'G') then
16       write(*, 140)
140      format (t10,'Which homogeneous cover type do you wish',
     & ' to use <Number>?')
         read *, ihomohab
         write(*, 1060) ihomohab
1060     format (t15,'Uniform cover type = ',i6/)
         write (9,1061) ihomohab
1061     format (i6,t20,"(Uniform cover type)")
       endif
c======================================================================
c
25     write(*, 200)
200    format (t10,'Enter the number of rows for the map')
       read *, irow
       write(*, 211)
211    format (t10,'Enter the number of columns for the map')
       read *, jcol
       if (irow .gt. maxprr .or. jcol .gt. maxprc) goto 25
       if (irow .le. 0) goto 25
       write(*, 2010) irow, jcol
2010   format(t15,'Rows = ',i6,' Cols = ',i6/)
       write (9,2011) irow
2011   format(i6,t20,"(Number of rows)")
       write (9,2012) jcol
2012   format(i6,t20,"(Number of columns)")
c======================================================================
c
c  enter data file for map
       if (maptype .eq. 'I') then
          p=1.0
          write(*, 220)
220       format (t10,'Enter name of input map file: ')
          read(*, 230) mapfile
230       format (a60)
          write(*, 2030) mapfile
2030      format (t15,'Input map name: ',a60/)
          write (9,2031) mapfile
2031      format (a60)
          write(*, 240)
240       format (t10,'Is there an elevation map '
     & 'for this input map? [Y]')
          read(*, 242) elevans
242       format (a1)
          write(*, 2033) elevans
2033      format (t15,'Use elev map? ',a1)
          write (9,247) elevans
247       format (a1,t20,"(Use elev map?)")
          if (elevans .ne. 'N' .and. elevans .ne. 'n') then
             elevans = 'Y'
             write(*, 243)
243          format (t10,'Enter name of elevation map file: ')
             read(*, 244) elevfile
244          format (a60)
             write(*, 245) elevfile
245          format (t15,'Elev map name: ',a60/)
             write (9,246) elevfile
246          format (a60)
c          select source of slope parameters
             write(*, 248)
248          format (/t10,'Use the file slope.matrix for slope',
     &       ' parameters? [Y]')
             read(*, 249) ans
249          format (a1)
             if (ans .ne. 'N' .and. ans .ne. 'n') then
                ans = 'Y'
                slopefil='slope.matrix'
             endif
             write(*, 2493) ans
2493         format (t15,'Use slope.matrix? ',a1/)
             write (9,252) ans
252          format (a1,t20,"(Use slope.matrix?)")
             if (ans .ne. 'Y') then
                write(*, 253)
253             format (t10,'Enter filename to use for slope',
     &    ' parameters ')
                read(*, 255) slopefil
255             format (a60)
                write(*, 2555) slopefil
2555            format (t15,'Slope parameters file: ',a60/)
                write (9,2556) slopefil
2556            format (a60)
             endif
c
c  read in slope parameter matrix
c
             open (20, file=slopefil,status='old')
             read (20,*,end=8888,err=9999) slopefct, slopemax
             close(20)
c
             write(*, 2558)
2558         format (t10,'Slope Parameters')
             write(*, 2559)
2559         format (t12,' Slope Effect Factor     Slope Effect',
     & ' Ceiling (degrees)')
             write(*, 9018) slopefct, slopemax
9018         format (t12,6x,f6.2,22x,f6.2/)
c
c  convert slopemax cutoff from degrees to normalized percent
             slopemax=tan(slopemax*3.14159265/180.0)
c
          endif		! there is an elevation map
       endif
c======================================================================
c
c  enter parameters for curdled maps
       if (maptype .eq. 'C') then
30        write(*, 250)
250       format (t10,'Enter the number of curdling levels ')
          read *,  icasno
          if (icasno .ne. 3) goto 30
c
          il = 1
          write(*, 270)
270       format (t10,'Enter number of cells, pcas, and qcas',
     & ' per level ')
          do ijk = 1, icasno
            read *, ncas(ijk), pcas(ijk), qcas(ijk)
            il = il*ncas(ijk)
          enddo
          write(*, 2050) icasno
2050       format (t15,'Curds (levels =',i2,') N      P          Q')
          do ijk = 1, icasno
            write(*, 2060) ncas(ijk), pcas(ijk), qcas(ijk)
2060         format (t24,i6,3x,g12.6,2x,g12.6/)
          enddo
c
c  calculate Pmap -- the totals
            pmap = pcas(1) * pcas(2) * pcas(3) 
     & + pcas(1) * (1.0 - pcas(2)) * qcas(3)
     & + (1.0 - pcas(1)) * qcas(2) * pcas(3) 
     & + (1.0 - pcas(1)) * (1.0 - qcas(2)) * qcas(3)
            write(*, 2080) il,pmap
2080         format (t15,'Geo. Totals',3x,i6,3x,g12.6/)
c
          if (il .ne. irow .or. pmap .eq. 0.0 .or. pmap .gt. 1.0) 
     &  goto 30
c  remove this next statement after curdling becomes generalized
          if (icasno .ne. 3) goto 30
       endif
c======================================================================
c  weather selection
c
       write(*, 111)
111    format (t10,'What type of weather during simulation; ',
     & '<U>niform, or <I>nput?  [U]')
       read(*, 113) wxtype
113    format (a1)
c
          if (wxtype .eq. 'u') wxtype = 'U'
c          if (wxtype .eq. 'r') wxtype = 'R'
          if (wxtype .eq. 'i') wxtype = 'I'
c
c       if (wxtype .ne. 'R' .and. wxtype .ne. 'I')
       if (wxtype .ne. 'I') wxtype = 'U'
c
       write(*, 1018) wxtype
1018   format (t15,'Wx type is ',a1/)
       write (9,1023) wxtype
1023   format (a1,t20,"(Wxtype)")
c
c  enter data file for weather
       if (wxtype .eq. 'I') then
c         select source of weather course
          write(*, 906)
906       format (/t10,'Use the file weather.sequence for weather',
     &    /t12,' course during simulations? [Y]')
          read(*, 926) ans
926       format (a1)
          if (ans .ne. 'N' .and. ans .ne. 'n') then
             ans = 'Y'
             wxfile='weather.sequence'
          endif
          write(*, 9006) ans
9006      format (t15,'Use weather.sequence? ',a1/)
          write (9,923) ans
923       format (a1,t20,"(Use weather.sequence?)")
          if (ans .ne. 'Y') then
             write(*, 946)
946          format (t10,'Enter filename to use for weather',
     & ' course during simulations ')
             read(*, 956) wxfile
956          format (a60)
             write(*, 9014) wxfile
9014         format (t15,'Weather course file: ',a60/)
             write (9,9017) wxfile
9017         format (a60)
          endif
c
       else	! wxtype is not I, prompt for wx params
c
c----------------------------------------------------------------------
c  enter synoptic wind speed class 
35        write(*, 300)
300       format (/t10,'Enter synoptic 20 ft. wind speed class: ',/t15,
     &    '0 = 0-5 MPH',t30,'none',/t15,'1 = 5-35 MPH',t30,'moderat',
     &    'e',/t15,'2 = > 35 MPH',t30,'strong')
          read *, ispeed
          if (ispeed .lt. 0 .or. ispeed .gt. 2) goto 35
          write(*, 3000) ispeed
3000      format (t15,'Synoptic wind speed class = ',i2/)
          write (9,3001) ispeed
3001      format (i2,t20,"(Wind speed class)")
c
c----------------------------------------------------------------------
c  enter wind direction
          if (ispeed .ne. 0) then
40           write(*, 320)
320          format (t10,'Enter the direction the wind is FROM')
             write(*, 330)
330          format (t10,'  as one of eight compass ordinals',
     &    ' [N, NE, E, SE, S, etc.]')
             read(*, 340) dir
340          format (a2)
             write (9,341) dir
341          format (a2,t20,"(Wind direction from)")
             if (dir .eq. 'n' .or. dir .eq. 'N') idir = 1
             if (dir .eq. 'ne' .or. dir .eq. 'NE') idir = 2
             if (dir .eq. 'e' .or. dir .eq. 'E') idir = 3
             if (dir .eq. 'se' .or. dir .eq. 'SE') idir = 4
             if (dir .eq. 's' .or. dir .eq. 'S') idir = 5
             if (dir .eq. 'sw' .or. dir .eq. 'SW') idir = 6
             if (dir .eq. 'w' .or. dir .eq. 'W') idir = 7
             if (dir .eq. 'nw' .or. dir .eq. 'NW') idir = 8
             if (idir .lt. 1 .or. idir .gt. 8) goto 40
             write(*, 3010) idir
3010         format (t15,'Wind source direction = ',i1/)
          else
             dir = 'N'
             idir = 1
          endif		! there is wind
c
c----------------------------------------------------------------------
c enter fuel moisture type
45        write(*, 350)
350       format (t10,'Enter the 1000 hr. fuel moisture class: ',/t15,
     &    '1 = < 12%',t30,'very dry',/t15,'2 = 12-16%',t30,'dry',/t15,
     &    '3 = > 16%',t30,'nominal')
          read *, iclimate
          if (iclimate .lt. 1 .or. iclimate .gt. 3) goto 45
          write(*, 3050) iclimate
3050      format (t15,'Fuel moisture class = ',i2/)
          write (9,3051) iclimate
3051      format (i2,t20,"(Fuel moisture class)")
c
       endif	! wxtype .ne. I
c
c======================================================================
c 
c  define type of fire starts
c
       if (wxtype .eq. 'I') then
          write(*, 908)
908       format (t10,'Do you want a sequence of fire starts through',
     & ' time? [Y]')
          read(*, 928) ignans
928       format (a1)
          if (ignans .ne. 'n' .and. ignans .ne. 'N') then
             ignans = 'Y'
          endif
c
          write(*, 9009) ignans
9009      format (t15,'Starts thru time? ',a1/)
          write (9,936) ignans
936       format (a1,t20,"(Starts thru time?)")
c
c         select source of fire starts sequence
          if (ignans .eq. 'Y') then
             write(*, 910)
910      format (/t10,'Use the file ignition.sequence for fire starts',
     &    ' during simulations? [Y]')
             read(*, 931) ans
931          format (a1)
             if (ans .ne. 'n' .and. ans .ne. 'N') then
                ans = 'Y'
                ignfile='ignition.sequence'
             endif
             write(*, 9111) ans
9111         format (t15,'Use ignition.sequence? ',a1/)
             write (9,924) ans
924          format (a1,t20,"(Use ignition.sequence?)")
             if (ans .ne. 'Y') then
                write(*, 959)
959             format (t10,'Enter filename to use for fire',
     & ' starts during simulations ')
                read(*, 953) ignfile
953             format (a60)
                write(*, 9024) ignfile
9024            format (t15,'Fire starts file: ',a60/)
                write (9,9027) ignfile
9027            format (a60)
             endif
c
          else		! variable wx, but no starts thru time
c
             write(*, 917)
917          format (t10,'All fires burning initially -',
     & /t12,'  no subsequent new starts will be simulated'/)
c
             write(*, 907)
907          format (t10,'Start with the first weather record, or'
     & /t12,'start the simulation on a particular date? [Y]')
             read(*, 927) ans
927          format (a1)
             if (ans .ne. 'n' .and. ans .ne. 'N') then
                ans = 'Y'
             endif
             write(*, 9008) ans
9008         format (t15,'Particular start date? ',a1/)
             write (9,925) ans
925          format (a1,t20,"(Particular start date?)")
c
             if (ans .eq. 'Y') then	! particular start date
                write(*, 957)
957             format (/t10,'Enter yr mo day hr min sec to start ')
                read *, iyr,imo,iday,ihr,imin,isec
                write(*, 9055) imo,iday,iyr,ihr,imin,isec
9055            format (t10,'Simulation starts ',i2,"/",i2,"/",i4,
     &               " at ",i2,":",i2,":",i2)
c
                write (9,934) iyr,imo,iday,ihr,imin,isec
934             format (i4,1x,5(i2,1x),t21,"(start date)")
c
                istime = timedate(iyr,imo,iday,ihr,imin,isec)
                ifirst(1) = iyr
                ifirst(2) = istime
c
             endif	! not starting on a particular date
c
          endif		! not a sequence of starts
c
c       else	! wxtype .ne. I
       endif	! constant weather
c
c      if not a sequence of ignitions, get type of initial starts
       if (ignans .ne. 'Y') then
c
          write(*, 380)
380       format (t10,'Fire starts <R>andom, <F>ixed, <C>enter, or ',
     & '<B>ottom Row? [C]')
          read(*, 390) startype
390       format (a1)
          if (startype .eq. 'r') startype = 'R'
          if (startype .eq. 'f') startype = 'F'
          if (startype .eq. 'c') startype = 'C'
          if (startype .eq. 'b') startype = 'B'
          if (startype .ne. 'R' .and. startype .ne. 'F' .and. startype
     & .ne. 'C' .and. startype .ne. 'B') startype = 'C'
          write(*, 3080) startype
3080      format (t15,'Fire starts type: ',a1/)
          write (9,3081) startype
3081      format (a1,t20,"(Fire starts type)")
c======================================================================
c
          if (startype .eq. 'C') then
             istarts=1
             mstart(1,1)=int(irow/2)
             mstart(1,2)=int(jcol/2)
          else if (startype .eq. 'B') then
             do i= 1, jcol
                mstart(i,1) = irow
                mstart(i,2) = i
             enddo
             istarts=jcol
          else		! startype is R or F
c
55           write(*, 400)
400          format (t10,'How many fire starts? ')
             read *, istarts
             if (istarts .gt. (irow*jcol)) goto 55
             write(*, 4000) istarts
4000         format (t15,'Number of fire starts = ',i6/)
             write (9,4001) istarts
4001         format (i6,t20,"(Number of starts)")
c
             if (startype .eq. 'F') then
                do i=1, istarts
                   write(*, 410) i
410   format (t10,'Fire start #', i3)
                   write(*, 420)
420   format (t10,'Specify x and y coordinates separated by a space')
                   write(*, 430)
430   format (t10,'  [where 1,1 is the upper left corner of the map]')
                   read *, mstart(i,2), mstart(i,1)
                   write (9,431) mstart(i,2), mstart(i,1)
431                format (i6,2x,i6)
                enddo
c
             endif
c
c  if starts are random, cannot test for flammability until 
c     map is generated or read in
c
             if (startype .ne. 'R') then
                do i=1, istarts
                   write(*, 4010) mstart(i,2), mstart(i,1)
4010               format (t15,'Start fire at: ', i6,',',i6/)
                enddo
             endif
c
          endif
c
       endif	! not a sequence of starts thru time
c======================================================================
c
       write(*, 450)
450    format (t10,'Enter the number of replications: ')
       read *, nrep
       write(*, 4030) nrep
4030   format (t15,'Number of reps = ',i6/)
       write (9,4031) nrep
4031   format (i6,t20,"(Number of reps)")
c
       if (nrep .gt. 1 .or. mc .eq. 1) then
          write(*, 460) nrep
460       format (t10,'Display map of cumulative risk of burn over all',
     &  i6,' replications? [Y]')
          read(*, 461) riskans
          if (riskans .ne. 'n' .and. riskans .ne. 'N') riskans = 'Y'
461       format (a1)
          write(*, 4032) riskans 
4032      format (t15,'Display cumulative risk? ',a1/)
          write (9,4033) riskans
4033      format (a1,t20,"(Display cumulative risk?)")
       endif
c
c======================================================================
c
c  enable firebrands?
       write(*, 605)
605    format (t10,'Enable firebrands? [Y]')
       read(*, 607) fbans
       if (fbans .ne. 'n' .and. fbans .ne. 'N') fbans = 'Y'
607    format (a1)
       write (9,608) fbans
608    format (a1,t20,"(Enable firebrands?)")
       write(*, 6025)  fbans
6025   format (t15,'Enable firebrands: ',a1/)
c======================================================================
c
c  define simulation end
       write(*, 700)
700    format (/t10,'End simulation after hitting <E>dge,')
       write(*, 701)
701    format (t15,'   after certain amount of <T>ime,')
       write(*, 702)
702    format (t15,'   after certain amount of area <B>urned,')
       write(*, 703)
703    format (t15,'   or after certain number of <F>ires? [E]')
       read(*, 710) stoptype
710    format (a1)
       if (stoptype .eq. 'e') stoptype = 'E'
       if (stoptype .eq. 't') stoptype = 'T'
       if (stoptype .eq. 'b') stoptype = 'B'
       if (stoptype .eq. 'f') stoptype = 'F'
       if (stoptype .ne. 'E' .and. stoptype .ne. 'T' .and. 
     &  stoptype .ne. 'B' .and. stoptype .ne. 'F') stoptype = 'E'
c
       write(*, 7000) stoptype
7000   format (t15,'End after: ',a1/)
       write (9,7001) stoptype
7001   format (a1,t20,"(End after?)")
c
c      force end of simulation for safety net
c       maxmov = maxprr*maxprc
c       simlen = maxmov
c
       if (stoptype .eq. 'T') then
75        write(*, 730)
730       format (t10,'End simulation after how many hours? ')
          read *, simlen
          if (simlen .le. 0) goto 75
c
          write(*, 6080) simlen
6080      format(t15,'Maximum hours = ',i12/)
          write (9,6081) simlen
6081      format(i12,t20,"(Simulation length (hours)?)")
c
       endif
c
       if (stoptype .eq. 'B') then
77        write(*, 732)
732       format (t10,'End simulation after how much area',
     & ' burned (in 2500 m2 cells)? ')
          read *, maxburned
          if (maxburned .le. 0) goto 77
c
          write(*, 6083) maxburned
6083      format(t15,'Maximum burned = ',i12/)
          write (9,6087) maxburned
6087      format(i12,t20,"(How much area burned?)")
c
       endif
c
       if (stoptype .eq. 'F') then
80        write(*, 740)
740       format (t10,'End simulation after how many fires? ')
          read *, maxfires
          if (maxfires .le. 0) goto 80
c
          write(*, 6090) maxfires
6090      format(t15,'Maximum fires = ',i12/)
          write (9,6091) maxfires
6091      format(i12,t20,"(How many fires?)")
c
       endif
c======================================================================
c
c  output a burn map file
       write(*, 750)
750    format (t10,'Output a final burn map? [N]')
       read(*, 760) outans
760    format (a1)
       if (outans .ne. 'y' .and. outans .ne. 'Y') then
          outans = 'N'
       else
          outans = 'Y'
       endif
       write(*, 7010) outans
7010   format (t15,'Output final burn map? ',a1/)
       write (9,7011) outans
7011   format (a1,t20,"(Output final burn map?)")
       if (outans .eq. 'Y') then
          write(*, 780)
780       format (t10,'Use burn.out as filename? [Y]')
          read(*, 790) ans
790       format (a1)
          if (ans .ne. 'n' .and. ans .ne. 'N') then
             ans = 'Y'
             outfile='burn.out'
          endif
          write (9,791) ans
791       format (a1,t20,"(Use burn.out as name?)")
          if (ans .ne. 'Y') then
             write(*, 800)
800          format (t10,'Name of final burn map file?')
             read(*, 810) outfile
810          format (a60)
             write (9,8001) outfile
8001         format (a60)
          endif
          write(*, 8002) outfile
8002      format (t15,'Final burn map file: ',a60)
          write(*, 820)
820       format (/t10,'What format for the final burn map file? [X',
     &    ']',/t15,'X = xpm display format',/t15,'R = rule analysis',
     &    ' format',/t15,'G = GRASS GIS format')
          read(*, 841) fmtans
841       format (a1)
          if (fmtans .eq. 'x') fmtans = 'X'
          if (fmtans .eq. 'r') fmtans = 'R'
          if (fmtans .eq. 'g') fmtans = 'G'
          if (fmtans .ne. 'X' .and. fmtans .ne. 'R' 
     &     .and. fmtans .ne. 'G') fmtans = 'X'
          write(*, 8010) fmtans
8010      format (/t15,'Final burn map format: ',a1/)
          write (9,8030) fmtans
8030      format (a1,t20,"(Format for burn map)")
       endif
c======================================================================
c 
c prompt for output to visualization tool
c 
       write(*, 511)
511    format (t10,'Display real-time visuals? [Y]')
       read(*, 512) waveans
512    format (a1)
       if (waveans .ne. 'n' .and. waveans .ne. 'N') then
          waveans='Y'
       endif
       write (9,513) waveans
513    format (a1,t20,"(Display visuals?)")
       write(*, 5001) waveans
5001   format (t15,'Display visuals? ',a1/)
       if (waveans .eq. 'Y') then
         write(*, 515)
515      format(t10,'How many simulated minutes per visual ',
     & 'display? [1]')
         read(*, 517) chkwave
517      format(f6.0)
         if (chkwave .eq. 0.) chkwave = 1.0
         write(9,519) chkwave
519      format(f6.0,t20,"(Minutes per visual display)")
         write(*, 520) chkwave
520      format(t10,'Minutes per visual display ',f6.0/)
       endif
c
c  save intermediate maps as output files?
       write(*, 181)
181    format (t10,'Save intermediate maps as output',
     & ' files? [N]')
       read(*, 182) intout
182    format (a1)
       if (intout .ne. 'y' .and. intout .ne. 'Y') then
         intout = 'N'
       else
         intout = 'Y'
       endif
       write (9,183) intout
183    format (a1,t20,"(Save intermediate maps in files?)")
       write(*, 194) intout
194    format(t15,'Save intermediate maps in files? ',a1)
       if (intout .eq. 'Y') then
27        write(*, 184) simlen
184       format (/t10,
     &         'Save intermediate maps to files at what interval? 
     &    <1-',i6,'>'/t11,'for example: 1 = Save every hour'
     &    /t24,'5  = Save every fifth hour'
     &    /t24,'10 = Save every tenth hour')
          read(*, 185) outfreq
185       format(i6)
          if (outfreq .lt. 1 .or. outfreq .gt. simlen) goto 27
          write(9,186) outfreq
186       format(i6,t20,"(Save map freq (hours))")
          write(*, 187) outfreq
187       format(/t15,'Save maps every',i6,' hours')
c
c  save initial habitat map as output file?
          write(*, 188)
188       format (t10,'Save initial habitat map as output',
     &    ' file? [N]')
          read(*, 189) habout
189       format (a1)
          if (habout .ne. 'y' .and. habout .ne. 'Y') then
            habout = 'N'
          else
            habout = 'Y'
          endif
          write (9,190) habout
190       format (a1,t20,"(Save habitat map in file?)")
          write(*, 191) habout
191       format(/t15,'Save habitat map in file? ',a1)
c
          write(*, 222)
222       format (/t10,'What format for output map files? [X',
     &    ']',/t15,'X = xpm display format',/t15,'R = rule analysis',
     &    ' format',/t15,'G = GRASS GIS format')
          read(*, 232) outfmtans
232       format (a1)
          if (outfmtans .eq. 'x') outfmtans = 'X'
          if (outfmtans .eq. 'r') outfmtans = 'R'
          if (outfmtans .eq. 'g') outfmtans = 'G'
          if (outfmtans .ne. 'X' .and. outfmtans .ne. 'R'
     &     .and. outfmtans .ne. 'G') outfmtans = 'X'
          write(*, 2022) outfmtans
2022      format (/t15,'Intermediate burn maps format: ',a1/)
          write (9,2032) outfmtans
2032      format (a1,t20,"(Format for intermediate maps)")
c
       endif
c
c======================================================================
       if (fbans .eq. 'Y') then
c
c         select source of firebrand abundance matrix
          write(*, 900)
900       format (/t10,'Use the file firebrand.matrix for firebrand',
     &    ' abundance numbers? [Y]')
          read(*, 920) ans
920       format (a1)
          if (ans .ne. 'n' .and. ans .ne. 'N') then
             ans = 'Y'
             firebrandfile='firebrand.matrix'
          endif
          write(*, 9000) ans
9000      format (t15,'Use firebrand.matrix? ',a1/)
          write (9,921) ans
921       format (a1,t20,"(Use firebrand.matrix?)")
          if (ans .ne. 'Y') then
             write(*, 940)
940          format (t10,'Enter filename to use for firebrand',
     & ' generation abundance matrix')
             read(*, 950) firebrandfile
950          format (a60)
             write(*, 9010) firebrandfile
9010         format (t15,'firebrand generation file: ',a60/)
             write (9,9011) firebrandfile
9011         format (a60)
          endif
c
c   read in firebrand probability matrix
c              ifbno(ihab)
          open (20, file=firebrandfile,status='old')
          read (20,*,end=8888,err=9999) (ifbno(i),i=1,ihab)
          close(20)
c
          write(*, 9015)
9015      format (t10,'Number of firebrands generated by habitat type')
          write(*, 9016)
9016      format (t12,'     LP0    LP1    LP2    LP3     NF')
          write(*, 9019) (ifbno(i),i=1,ihab)
9019      format (t12,16(1x,i6)/)
c======================================================================
c
c  select source of firebrand ignition matrix
          write(*, 960)
960       format (/t10,'Use the file ignition.matrix for firebrand')
          write(*, 961)
961       format (/t15,' ignition establishment probabilities? [Y]')
          read(*, 970) ans
970       format (a1)
          if (ans .ne. 'n' .and. ans .ne. 'N') then
             ans = 'Y'
             ignitionfile='ignition.matrix'
          endif
          write(*, 9020) ans
9020      format (t15,'Use ignition.matrix? ',a1/)
          write (9,971) ans
971       format (a1,t20,"(Use ignition.matrix?)")
          if (ans .ne. 'Y') then
             write(*, 980)
980          format (t10,'Enter filename to use for ignition',
     &    ' establishment matrix')
             read(*, 990) ignitionfile
990          format (a60)
             write(*, 9030) ignitionfile
9030         format (t15,'Ignition establishment file: ',a60/)
             write (9,9031) ignitionfile
9031         format (a60)
          endif
c
c   read in ignition establishment matrix
c    ignition  i   fuel moisture type
c              j   habitat
          open (21, file=ignitionfile,status='old')
          do i = 1, 3
             read (21,*,end=8888,err=9999) ii
             read (21,*,end=8888,err=9999) (ignition(ii,j),
     &     j=1,ihab)
          enddo
          close(21)
c
          write(*, 9035)
9035      format (t5,'Climate     Probability of Firebrand',
     & ' Ignition')
          write(*, 9036)
9036      format (t5,'              LP0    LP1    LP2    LP3     NF')
          do i = 1, 3
             write(*, 9040) i,(ignition(i,j),j=1,ihab)
          enddo
9040      format (t5,i6,5x,16(2x,f5.3))
c
       endif		! firebrands enabled
c======================================================================
c 
       write(*, 530)
530    format (/t10,'Use the file fire.matrix for fire transition
     & probabilities? [Y]')
       read(*, 531) ans
531    format (a1)
       if (ans .ne. 'n' .and. ans .ne. 'N') then
          ans = 'Y'
          firefile='fire.matrix'
       endif
       write (9,532) ans
532    format (a1,t20,"(Use fire.matrix?)")
       write(*, 5000) ans
5000   format (t15,'Use fire.matrix? ',a1/)
       if (ans .ne. 'Y') then
          write(*, 540)
540       format (t10,'Enter filename to use for fire',
     &' probability matrix')
          read(*, 550) firefile
550       format (a60)
          write(*, 5020) firefile
5020      format (t15,'Fire matrix file: ',a60/)
          write (9,5021) firefile
5021      format (a60)
       endif
c
c   read in fire matrix
c    firemat   i   fuel moisture type
c              k   'from' habitat
c              j   'to' habitat
       open (17, file=firefile,status='old')
       do i = 1, 3
          read (17,*,end=8888,err=9999) ii
          read (17,*,end=8888,err=9999) ((firemat(ii,k,j), j=1,ihab), 
     &          k=1,ihab)
       enddo
       close(17)
c
c   print out fire matrix
c   if standard habitats are used
       if (ihab .eq. 5) then
          write(*, 5050)
5050      format (t5,'Fire pattern probability matrix')
          write(*, 5052)
5052      format (/t10,'Very Dry Fuel - Class 1')
          write(*, 5053)
5053      format (t27,'        Present Habitat')
          write(*, 5054)
5054      format (t27,'LP0    LP1    LP2    LP3    NF')
          write(*, 5056) (firemat(1,1,j),j=1,ihab)
5056      format (t7,'           LP0',3x,10(2x,f5.3))
          write(*, 5058) (firemat(1,2,j),j=1,ihab)
5058      format (t7,'Adjacent   LP1',3x,10(2x,f5.3))
          write(*, 5060) (firemat(1,3,j),j=1,ihab)
5060      format (t7,' Habitat   LP2',3x,10(2x,f5.3))
          write(*, 5062) (firemat(1,4,j),j=1,ihab)
5062      format (t7,'           LP3',3x,10(2x,f5.3))
          write(*, 5064) (firemat(1,5,j),j=1,ihab)
5064      format (t7,'           NF ',3x,10(2x,f5.3))
c
          write(*, 5066)
5066      format (/t10,'Dry Fuel - Class 2')
          write(*, 5067)
5067      format (t27,'        Present Habitat')
          write(*, 5068)
5068      format (t27,'LP0    LP1    LP2    LP3    NF')
          write(*, 5070) (firemat(2,1,j),j=1,ihab)
5070      format (t7,'           LP0',3x,10(2x,f5.3))
          write(*, 5072) (firemat(2,2,j),j=1,ihab)
5072      format (t7,'Adjacent   LP1',3x,10(2x,f5.3))
          write(*, 5074) (firemat(2,3,j),j=1,ihab)
5074      format (t7,' Habitat   LP2',3x,10(2x,f5.3))
          write(*, 5076) (firemat(2,4,j),j=1,ihab)
5076      format (t7,'           LP3',3x,10(2x,f5.3))
          write(*, 5078) (firemat(2,5,j),j=1,ihab)
5078      format (t7,'           NF ',3x,10(2x,f5.3))
c
          write(*, 5080)
5080      format (/t10,'Nominal Fuel - Class 3')
          write(*, 5081)
5081      format (t27,'        Present Habitat')
          write(*, 5082)
5082      format (t27,'LP0    LP1    LP2    LP3    NF')
          write(*, 5084) (firemat(3,1,j),j=1,ihab)
5084      format (t7,'           LP0',3x,10(2x,f5.3))
          write(*, 5086) (firemat(3,2,j),j=1,ihab)
5086      format (t7,'Adjacent   LP1',3x,10(2x,f5.3))
          write(*, 5088) (firemat(3,3,j),j=1,ihab)
5088      format (t7,' Habitat   LP2',3x,10(2x,f5.3))
          write(*, 5090) (firemat(3,4,j),j=1,ihab)
5090      format (t7,'           LP3',3x,10(2x,f5.3))
          write(*, 5092) (firemat(3,5,j),j=1,ihab)
5092      format (t7,'           NF ',3x,10(2x,f5.3))
c
       endif
c======================================================================
       write(*, 830)
830    format (/t10,'Use the file spread.matrix for fire spread
     & parameters? [Y]')
       read(*, 831) ans
831    format (a1)
       if (ans .ne. 'n' .and. ans .ne. 'N') then
          ans = 'Y'
          spreadfile='spread.matrix'
       endif
       write (9,832) ans
832    format (a1,t20,"(Use spread.matrix?)")
       write(*, 8000) ans
8000   format (t15,'Use spread.matrix? ',a1/)
       if (ans .ne. 'Y') then
          write(*, 840)
840       format (t10,'Enter filename to use for fire',
     &' spread parameters matrix')
          read(*, 850) spreadfile
850       format (a60)
          write(*, 8020) spreadfile
8020      format (t15,'Fire spread file: ',a60/)
          write (9,8021) spreadfile
8021      format (a60)
       endif
c
c   read in fire spread matrix
c    spreadmat   i   fuel moisture type
c                k   'from' habitat
c                j   wind speed class (0 to 2)
       open (17, file=spreadfile,status='old')
       do i = 1, 3
          read (17,*,end=8888,err=9999) ii
          read (17,*,end=8888,err=9999) ((spreadmat(ii,k,j), k=1,ihab),
     &          j=0,2)
       enddo
       close(17)
c
c
c   print out fire spread matrix
c   if standard habitats are used
       if (ihab .eq. 5) then
          write(*, 8050)
8050      format (t5,'Fire spread parameter matrix')
          write(*, 8051)
8051      format (t5,'Units are 10-second timesteps')
          write(*, 8052)
8052      format (/t10,'Very Dry Fuel - Class 1')
          write(*, 8053)
8053      format (t27,'        Present Habitat')
          write(*, 8054)
8054      format (t26,'LP0         LP1         LP2         LP3',
     &     '          NF')
          write(*, 8056) (spreadmat(1,k,0),k=1,ihab)
8056      format (t7,'       No Wind',1x,10(i7,5x))
          write(*, 8058) (spreadmat(1,k,1),k=1,ihab)
8058      format (t7,'  Wind Speed 1',1x,10(i7,5x))
          write(*, 8060) (spreadmat(1,k,2),k=1,ihab)
8060      format (t7,'  Wind Speed 2',1x,10(i7,5x))
c
          write(*, 8066)
8066      format (/t10,'Dry Fuel - Class 2')
          write(*, 8067)
8067      format (t27,'        Present Habitat')
          write(*, 8068)
8068      format (t26,'LP0         LP1         LP2         LP3',
     &     '          NF')
          write(*, 8070) (spreadmat(2,k,0),k=1,ihab)
8070      format (t7,'       No Wind',1x,10(i7,5x))
          write(*, 8072) (spreadmat(2,k,1),k=1,ihab)
8072      format (t7,'  Wind Speed 1',1x,10(i7,5x))
          write(*, 8074) (spreadmat(2,k,2),k=1,ihab)
8074      format (t7,'  Wind Speed 2',1x,10(i7,5x))
c
          write(*, 8080)
8080      format (/t10,'Nominal Fuel - Class 3')
          write(*, 8081)
8081      format (t27,'        Present Habitat')
          write(*, 8082)
8082      format (t26,'LP0         LP1         LP2         LP3',
     &     '          NF')
          write(*, 8084) (spreadmat(3,k,0),k=1,ihab)
8084      format (t7,'       No Wind',1x,10(i7,5x))
          write(*, 8086) (spreadmat(3,k,1),k=1,ihab)
8086      format (t7,'  Wind Speed 1',1x,10(i7,5x))
          write(*, 8088) (spreadmat(3,k,2),k=1,ihab)
8088      format (t7,'  Wind Speed 2',1x,10(i7,5x))
c
       endif
c
c======================================================================
c
c         select source of heat content matrix
          write(*, 903)
903       format (/t10,'Use the file heat.matrix for heat',
     &    ' content of each fuel type',
     &    /t12,' to calculate burn severity? [Y]')
          read(*, 911) ans
911       format (a1)
          if (ans .ne. 'n' .and. ans .ne. 'N') then
             ans = 'Y'
             heatfile='heat.matrix'
          endif
          write(*, 9003) ans
9003      format (t15,'Use heat.matrix? ',a1/)
          write (9,913) ans
913       format (a1,t20,"(Use heat.matrix?)")
          if (ans .ne. 'Y') then
             write(*, 943)
943          format (t10,'Enter filename to use for heat',
     & ' content of fuel types matrix')
             read(*, 958) heatfile
958          format (a60)
             write(*, 9118) heatfile
9118         format (t15,'Heat content file: ',a60/)
             write (9,9119) heatfile
9119         format (a60)
          endif
c
c   read in heat content matrix
c              ifbno(ihab)
          open (20, file=heatfile,status='old')
          read (20,*,end=8888,err=9999) (heat(i),i=1,ihab)
          close(20)
c
          write(*, 9085)
9085      format (t5,'Heat Content of each cell by Habitat Type',/)
          write(*, 9086)
9086      format (t26,'LP0         LP1         LP2         LP3',
     &     '          NF')
          write(*, 9089) (heat(i),i=1,ihab)
9089      format (t7,'              ',1x,10(i7,5x))
c
c
c      calculate burn severity range for these inputs
       sevmax = 0
       sevmin = 9999999
       do i = 1,3
          do k = 1,ihab
             do j = 0,2
                if (float(heat(k))/float(spreadmat(i,k,j)) .gt. sevmax)
     &            sevmax=float(heat(k))/float(spreadmat(i,k,j))
                if (float(heat(k))/float(spreadmat(i,k,j)) .lt. sevmin)
     &            sevmin=float(heat(k))/float(spreadmat(i,k,j))
             enddo
          enddo
       enddo
       print *, 'sevmin, max: ', sevmin, sevmax
c
c======================================================================
c
c  select source of wind speed bias probability matrix
       write(*, 570)
570    format (/t10,'Use the file wind.matrix for wind speed bias',
     & ' probabilities? [Y]')
       read(*, 580) ans
580    format (a1)
       if (ans .ne. 'n' .and. ans .ne. 'N') then
          ans = 'Y'
          windfile='wind.matrix'
       endif
       write(*, 5095) ans
5095   format (t15,'Use wind.matrix? ',a1/)
       write (9,581) ans
581    format (a1,t20,"(Use wind.matrix?)")
       if (ans .ne. 'Y') then
          write(*, 590)
590       format (t10,'Enter filename to use for the wind speed bias',
     & ' probability matrix')
          read(*, 600) windfile
600       format (a60)
          write(9,601) windfile
601       format (a60,t20,"(Wind matrix file)")
          write(*, 6000) windfile
6000      format (t15,'Wind matrix file: ',a60/)
       endif
c
c   read in wind speed bias matrix
c    windmat   i   windspeed class
c              j   compass ordinal index
       open (34, file=windfile,status='old')
       do i = 1, 3
          read (34,*,end=8888,err=9999) ii
          read (34,*,end=8888,err=9999) (windmat(ii,j),
     &  j=1,8)
       enddo
       rewind(34)
       do i = 1, 3
          read (34,*,end=8888,err=9999) ii
          read (34,*,end=8888,err=9999) (windmat(ii,j+8),
     &  j=1,8)
       enddo
       close(34)
c======================================================================
c
       if (wxtype .ne. 'I') then
          if (ispeed .ne. 0) then
             write(*, 6050) dir
6050         format (t5,'Wind is from the ',a2/)
          else
             write(*, 6051)
6051         format (t5,'There is no wind.'/)
          endif
       endif
c
       write(*, 6052)
6052   format (t15,'None',17x,'Moderate',14x,'Strong')
c
       write(*, 6010)
6010   format (t17,'N',21x,'N',21x,'N'/)
c
       write(*, 6020) windmat(0,9-idir+7), windmat(0,9-idir),
     & windmat(0,9-idir+1), windmat(1,9-idir+7), 
     & windmat(1,9-idir), windmat(1,9-idir+1),
     & windmat(2,9-idir+7), windmat(2,9-idir),
     & windmat(2,9-idir+1)
6020   format (t9,f4.2,2x,f4.2,2x,f4.2,6x,f4.2,2x,f4.2,2x,f4.2,6x,
     & f4.2,2x,f4.2,2x,f4.2/)
c
       write(*, 6021) windmat(0,9-idir+6), windmat(0,9-idir+2),
     & windmat(1,9-idir+6), windmat(1,9-idir+2),
     & windmat(2,9-idir+6), windmat(2,9-idir+2)
6021   format (t7,'W ',f4.2,8x,f4.2,' E  W ',f4.2,8x,f4.2,' E  W ',
     & f4.2,8x,f4.2,' E'/)
c	
       write(*, 6022) windmat(0,9-idir+5), windmat(0,9-idir+4),
     & windmat(0,9-idir+3), windmat(1,9-idir+5),
     & windmat(1,9-idir+4), windmat(1,9-idir+3),
     & windmat(2,9-idir+5), windmat(2,9-idir+4),
     & windmat(2,9-idir+3)
6022   format (t9,f4.2,2x,f4.2,2x,f4.2,6x,f4.2,2x,f4.2,2x,f4.2,6x,
     & f4.2,2x,f4.2,2x,f4.2/)
c
       write(*, 6023)
6023   format (t17,'S',21x,'S',21x,'S'/)
c======================================================================
c
c  select scale for a pixel
       write(*, 620)
620    format (t10,'Use standard scale of 50m pixel units? [Y]')
       read(*, 630) ans
630    format (a1)
       if (ans .ne. 'n' .and. ans .ne. 'N') then
          scale=1.0
          ans = 'Y'
          write(*, 6030) ans
6030      format (t15,'Use standard scale? ',a1/)
          write (9,631) ans
631       format (a1,t20,"(Use standard 50m scale?)")
       endif
       if (ans .ne. 'Y') then
          write(*, 640)
640       format (t10,'Enter scale multiplier for 50m pixel units')
          read *, scale
          write(*, 6040) scale
6040      format (t15,'Scale multiplier = ',g12.6/)
          write (9,6041) scale
6041      format (g12.6,t20,"(Scale of single pixel)")
       endif
c======================================================================
c
c  read mean for firebrand dispersal distribution from matrix by wind speed
c         select source of firebrand mean dispersion matrix
          write(*, 715)
715       format (t10,'Use the file fbmean.matrix for')
          write(*, 716)
716       format (t12,'means of firebrand dispersal distances? [Y]')
          read(*, 725) ans
725       format (a1)
          if (ans .ne. 'n' .and. ans .ne. 'N') then
             fbmeanfile='fbmean.matrix'
             ans = 'Y'
             write(*, 7100) ans
7100         format (t15,'Use fbmean.matrix? ',a1/)
             write (9,726) ans
726          format (a1,t20,"(Use fbmean.matrix?)")
          endif
          if (ans .ne. 'Y') then
             write(*, 735)
735          format (t10,'Enter filename to use for means',
     & ' of firebrand dispersals matrix')
             read(*, 745) fbmeanfile
745          format (a60)
             write(*, 7150) fbmeanfile
7150         format (t15,'Firebrand mean dispersal file: ',a60/)
             write (9, 7151) fbmeanfile
7151         format (a60)
          endif
c
c   read in firebrand mean dispersal matrix
c              xfbmean(ispeed)
          open (22, file=fbmeanfile,status='old')
          read (22,*,end=8888,err=9999) (xfbmean(i),i=0,2)
          close(22)
c======================================================================
c
          write(*, 7160)
7160      format (t5,'Mean dispersal distance for firebrands',
     & ' by wind speed type')
          write(*, 7170)
7170      format (t13,'None       Moderate      Strong')
          write(*, 7180) (xfbmean(i),i=0,2)
7180      format (t11,f6.2,7x,f6.2,7x,f6.2/)
c======================================================================
c
c       write(*, 6050) xmean
c6050   format (t15,'Mean distance (exponential distribution)= ',g12.6//)
c       write(*, 6060) xmean
c6060   format (t15,'Generating exponential distribution',
c     & ' with mean = ',g12.6/)
c       do i = 1, maxprm*maxprm
c          call exponen (xmean, irnd(i), jrnd(i))
c       enddo
c======================================================================
c 
       close (9)
       write(*, 902)
902    format (///t10,'EMBYR is running ...'///)
       return
c======================================================================
c
c Error traps
8888   write(*, 888)
888    format (t10,'End of file encountered on file read!')
       stop
9999   write(*, 999)
999    format (t10,'Error during file read!')
       stop
c
c
c88888   write(*, 882) ignfile
c882    format (t10,'Hit end of records in fire starts file ',a60)
c       stop
c
c99999   write(*, 992)
c992    format (t10,'Bad data in first records of Fire Starts file!')
c       stop
c
       end
c======================================================================
c
      real*4 function rannorm(iseed)
      implicit none
      real*4 dumsum, getrandom
      integer*4 i, iseed
      dumsum = 0.0
c
      do i = 1, 4
        dumsum = dumsum + getrandom()
      enddo
c
c  get normal random deviate (rannorm) from uniform
      rannorm = sqrt(12.0)*((dumsum/2.0) - 1.0)
c
       return
       end
