c  genmap.f
       subroutine genmap
       implicit none
c
       include 'parm.i'
       include 'common.i'
       integer*4 i, j
       real*4 getrandom
       external getrandom
c
c   set entire map to zero
       do j = 1, jcol
          do i = 1, irow
             maphab(i,j) = 0
          enddo
       enddo
c
c   select map generation procedure
c      r :: random map -- simple p
c      c :: curdled map
c      i :: input map
c
       if (maptype .eq. 'R' .or. maptype .eq. 'U') call randmap
       if (maptype .eq. 'I') call inputmap
       if (maptype .eq. 'C') call curdmap
       if (maptype .eq. 'G') call gradmap
c
c   generate map classes
       write(*, 2000) ihab
2000   format (t10,'There are ',i6,' fuel types')
       if (maptype .ne. 'I' .and. maptype .ne. 'U') then
          do j = 1, jcol
             do i = 1, irow
                if (maphab(i,j) .eq. 1)
     &            maphab(i,j) = int(getrandom()*ihab) + 1
             enddo
          enddo
       endif
c
       if (maptype .eq. 'U') then
          do j = 1, jcol
             do i = 1, irow
                if (maphab(i,j) .eq. 1)
     &            maphab(i,j) = ihomohab
             enddo
          enddo
       endif
c
c   set borders to -9
c      do i = 1, irow+2
c          maphab(i,1) = -9
c          maphab(i,jcol+2) = -9
c       enddo
c
c       do j = 1, jcol+2
c          maphab(1,j) = -9
c          maphab(irow+2,j) = -9
c       enddo
c
       write(*, 2010)
2010   format(t10,'Fuel map is generated')
       return
       end
c
c**********************************************************
       subroutine xpmsevmap
c
c  output routine for xpm x-window display tool
c
c if mapfire value is 0, then not burned, show maphab value thru
c if mapfire value gt 0, then burning, add # of hab cats to mapfire
c if mapfire value lt 0, then burned, will be *
c
       implicit none
       include 'parm.i'
       include 'common.i'
       integer*4 i
c
c don't fill up the disk, but allow the final burn map write
       if (ifile .gt. 150 .and. ifile .ne. 33) then
          write(*, 113)
113       format ('Limit of 50 intermediate output maps reached... no
     & more maps will be output... ')
          return
       endif
c
c  make original ignition points orange
       do  i=1, istarts
         mapfire(mstart(i,1),mstart(i,2)) = 8
       enddo
       call writexpmsevmap(ifile, istarts, imov(2), jcol, irow, maphab,
     &      maxprr, mapfire)
       ifile = ifile + 1
c
       return
       end
c
c**********************************************************
       subroutine rulemap 
c
c  output routine for map analysis by rule program
       implicit none
       include 'parm.i'
       include 'common.i'
       integer*4 ijunk(maxprr)
       integer*4 i, j
c
c don't fill up the disk, but allow the final burn map write
       if (ifile .gt. 150 .and. ifile .ne. 33) then
          write(*, 116)
116       format ('Limit of 20 intermediate output maps reached... no
     & more maps will be output... ')
          return
       endif
c
c  output map
       write(*, 111) ifile, float(imov(2))/360.
111     format ('RULE map file fort.', i3, ' generated at ', g12.6,
     & ' hours')
       do i = 1, irow
          do j = 1, jcol
c             ijunk(j) = mapfire(i,j)
c             if (ijunk(j) .ne. 0) ijunk(j) = 1
c
c            cell is unburned not forested (notflam, water, or nf)
             if (mapfire(i,j) .eq. 0 .and. 
     &        (maphab(i,j) .eq. 0 .or. maphab(i,j) .eq. 5 .or.
     &        maphab(i,j) .eq. 6)) then
                ijunk(j) = 0
c            cell is unburned forested
             else if (mapfire(i,j) .eq. 0) then
                ijunk(j) = maphab(i,j)
c            cell is burned
             else
                ijunk(j) = 5
             endif
          enddo
          write(ifile,114) (ijunk(j), j=1, jcol)
c114       format (1x,9000i6)
114       format (1x,9000i2)
       enddo
c
       ifile = ifile + 1
c
       return
       end
c
c**********************************************************
       subroutine grassmap 
c
c  output routine for a grass maplayer
       implicit none
       include 'parm.i'
       include 'common.i'
       integer*4 i, j
       real*4 getrandom
       external getrandom
c
c don't fill up the disk, but allow the final burn map write
       if (ifile .gt. 150 .and. ifile .ne. 33) then
          write(*, 115)
115       format ('Limit of 20 intermediate output maps reached... no
     & more maps will be output... ')
          return
       endif
c
c  output map
       write(*, 110) ifile, float(imov(2))/360.
110     format ('GRASS map file fort.', i3, ' generated at ', g12.6,
     & ' hours')
       do i = 1, irow
          write(ifile,116) (mapfire(i,j), j=1, jcol)
116       format (1x,9000i1)
       enddo
c
       ifile = ifile + 1
c
       return
       end
c
c**********************************************************
       subroutine randmap
       implicit none
       include 'parm.i'
       include 'common.i'
       integer*4 i, j
       real*4 y
       real*4 getrandom
       external getrandom
c
          do j = 1, jcol
             do i = 1, irow
                y=getrandom()
                if (y.le.p) maphab(i,j) = 1
             enddo
          enddo
       return
       end
c
c**********************************************************
       subroutine gradmap
       implicit none
       include 'parm.i'
       include 'common.i'
       integer*4 i, j
       real*4 y
       real*4 getrandom
       external getrandom
c
          do i = 1, irow
             p=float(i)*(1/float(irow))
             do j = 1, jcol
                y=getrandom()
                if (y.le.p) maphab(i,j) = ihomohab
             enddo
          enddo
       return
       end
c
c**********************************************************
      subroutine inputmap
      implicit none
      include 'parm.i'
      include 'common.i'
      integer*4 i, j
c
c   input map from a data file
      open (14, file=mapfile, status='old')
c
      do i = 1, irow
        read (14,118) (maphab(i,j), j=1, jcol)
118     format (9000i1)
      enddo
c
      close(14)
      rewind(14)
c
c
c   input elevation map from a data file
      if (elevans .eq. 'Y') then
         open (14, file=elevfile, status='old')
c
         do i = 1, irow
           read (14,119) (mapelev(i,j), j=1, jcol)
119        format (9000i4)
         enddo
c
      endif
c
      close(14)
      rewind(14)
c
      return
      end
c**********************************************************
       subroutine xpmrisk
c
c  output routine for xpm x-window display tool
c
c  write xpm format map with grayshades of cumulative risk layer
c
       implicit none
       include 'parm.i'
       include 'common.i'
       integer*4 i

       outfile='risk.xpm'
       open (40,file=outfile,status='unknown')
c
c  flag original ignition points as -1
c  make original ignition points white below
       do i=1, istarts
          mapprob(mstart(i,1),mstart(i,2)) = -1
       enddo
      call writexpmriskmap(imov(2), jcol, irow, mc, nrep, maxprr, 
     &      maphab, mapprob)
       return
       end
c
c**********************************************************
       subroutine rulerisk
c
c  output routine for map analysis by rule program
       implicit none
       include 'parm.i'
       include 'common.i'
       integer*2 itemp(maxprr)
       integer*4 i, j
c
       outfile='risk.rule'
       open (40,file=outfile,status='unknown')
c
c  output map
       write(*, 99) float(imov(2))/360.
99     format ('RULE map file risk.rule generated at ',g12.6,
     & ' hours')
c
       do i = 1, irow
          do j = 1, jcol
             itemp(j) = (mapprob(i,j)*100)/nrep
             if (mc .eq. 1) itemp(j) = (mapprob(i,j)*100)/25
          enddo
          write(40,114) (itemp(j), j=1, jcol)
114       format (1x,9000i6)
       enddo
       close (40)
c
       return
       end
c
c**********************************************************

