      subroutine fire
c  EMBYR program simulates fire events over very large regions
c   creates (or inputs) a map, simulates the spread
c   of fire on the map, and creates output files for analysis
c   
c   based on preliminary code by
c     Robert H. Gardner
c
c  program written by
c     William W. Hargrove
c   Computational Physics and Engineering Division
c   Oak Ridge National Laboratory
c   P.O. Box 2008, Mail Stop 6274
c   Oak Ridge, TN  37831-6274
c       (865) 241-2748
c
c       implicit real*4 (a-h,o-z)
      implicit none
       include 'parm.i'
       include 'common.i'
c
       external sleep

       integer*4 i,j,k, drawpixmap
       real*4 alt, az, c, x, y, slope, aspect
       external drawpixmap
c
c  flag switch if monte carlo within a single season is desired
c    years should increment in weather and ignition file to 
c    signify end-of-season
       mc = 1
c
       if (mc .eq. 1) iadd = 0
c
       idtype = 2
       idumm = 0
       mapcolor = 'fire.cmap\0'
       probcolor = 'risk.cmap\0'
       habtitle = 'fuel - embyr fire model\0'
       firetitle = 'burn - embyr fire model\0'
       probtitle = 'risk - embyr fire model\0'
       slopetitle = 'slope - embyr fire model\0'
       asptitle = 'relief - embyr fire model\0'
       windtitle = '    '

c  set stand-replacing fire severity threshold
       srthresh = 75
c
c  set start for numerical sequence fort.xx output filenames
       ifile = 100
c
c  obtain input parameters for model simulation
       call input
c  set maximum age for fires
       ifage = 1
c
c  initialize statistical arrays
       call statinit
       open (11, file='cfd.scratch',status='unknown')
c       open (32, file='exp.distance',status='unknown')
       open (10, file='radius.scratch',status='unknown')
       if(outans .eq. 'Y') open (33, file=outfile,status='unknown')
c
c======================================================================
c   begin simulations
       do irep = 1, nrep
c
c  initializations
          ifcnt =0
          edgenbr = 0
          edgefb = 0
          maxfiresend = 0
          maxburnedend = 0
          iseos = 0
          iburned = 0
          sumrsqd = 0.0
          sumr = 0.0
          bsumr = 0.0
          bsumrsqd = 0.0
          maxradbd = 0
          maxradbn = 0
c
c  initialize counter for visualizations
          ivis = 1
c  initialize counter for intermediate files
          iouts = 1
c
c
c   generate random maps of irow and jcol dimensions
          call genmap
c
c  goto visualization tool for output of habitat map
c
          if (waveans .eq. 'Y' .and. irep .eq. 1) then
             k=0
             do i=1,irow
                do j=1,jcol
                   idispvec(k)=maphab(i,j)
                   k=k+1
                enddo
             enddo
c  get the right pixmap to display in
             if (irep .eq. 1) then
                ipixid = -1
             else
                ipixid = ipixids(1)
             endif
             ierr=drawpixmap(ipixid,jcol,irow,idtype,idispvec,
     & idumm,mapcolor,habtitle)
             ipixids(1)=ipixid
             if (ierr .lt. 0) call pixmaperror(ierr)
          endif
c
c
c  goto visualization tool for output of elevation maps
c  equations for slope and aspect are from:
c  horn, b.k.p., 1981.  hill shading and the reflectance map.  proceedings
c       of the i.e.e.e., 69(1):14-47.
c
c  calculate and display aspect map
          if (waveans .eq. 'Y' .and. elevans .eq. 'Y' 
     & .and. irep .eq. 1) then
c  set sun altitude above horizon in degrees (0 to 90)
             alt=40.
c  set sun azimuth in degrees west of north (-1 to 360)
             az=315.
             k=0
             do i=2,irow-1
                do j=2,jcol-1
c
                x=(mapelev(i-1,j-1)+2.*mapelev(i,j-1)+mapelev(i+1,j-1)
     &            -mapelev(i-1,j+1)-2.*mapelev(i,j+1)-mapelev(i+1,j+1))
     &            /(8.0*50.0)
c
                y=(mapelev(i-1,j-1)+2.*mapelev(i-1,j)+mapelev(i-1,j+1)
     &            -mapelev(i+1,j-1)-2.*mapelev(i+1,j)-mapelev(i+1,j+1))
     &            /(8.0*50.0)
c
                slope=90. - atan(sqrt(x*x + y*y))*180.0/3.14159265
                if (x .eq. 0. .and. y .eq. 0.) then
                   aspect=360.
                else
                   aspect=atan2(x,y)*180.0/3.14159265
                endif
c
                c=sin(alt*3.14159265/180.0)*sin(slope*3.14159265/180.0)+
     &               cos(alt*3.14159265/180.0)*
     &               cos(slope*3.14159265/180.0)*
     &               cos( (az-aspect) *3.14159265/180.0)
c
                if (c .le. 0.) then
                   idispvec(k)=0
                else
                   idispvec(k)=nint(c*100.)
                endif
c                print*, slope, aspect, c, idispvec(k)
c
                k=k+1
                enddo
             enddo
c
c  get the right pixmap to display in
             if (irep .eq. 1) then
                ipixid = -1
             else
                ipixid = ipixids(4)
             endif
             ierr=drawpixmap(ipixid,jcol-2,irow-2,idtype,idispvec,
     & idumm,probcolor,asptitle)
             ipixids(4)=ipixid
             if (ierr .lt. 0) call pixmaperror(ierr)
c
c  calculate and display slope map
c
             k=0
             do i=2,irow-1
                do j=2,jcol-1
c
                x=(mapelev(i-1,j-1)+2.*mapelev(i,j-1)+mapelev(i+1,j-1)
     &            -mapelev(i-1,j+1)-2.*mapelev(i,j+1)-mapelev(i+1,j+1))
     &            /(8.0*50.0)
c
                y=(mapelev(i-1,j-1)+2.*mapelev(i-1,j)+mapelev(i-1,j+1)
     &            -mapelev(i+1,j-1)-2.*mapelev(i+1,j)-mapelev(i+1,j+1))
     &            /(8.0*50.0)
c
c  multiply degrees slope * 2 and then cutoff at 90 (=45 degrees)
                   idispvec(k) = ifix( atan(sqrt(x*x + y*y))*
     &               180.0/3.14159265 )*2
                   if (idispvec(k) .ge. 90) idispvec(k) = 90
                   k=k+1
                enddo
             enddo
c             write(20,53) (idispvec(l), l=1,k)
c53           format(398(i3))
c
c  get the right pixmap to display in
             if (irep .eq. 1) then
                ipixid = -1
             else
                ipixid = ipixids(5)
             endif
             ierr=drawpixmap(ipixid,jcol-2,irow-2,idtype,idispvec,
     & idumm,probcolor,slopetitle)
             ipixids(5)=ipixid
             if (ierr .lt. 0) call pixmaperror(ierr)
c
          endif		! waveans = y and elevans = y and irep = 1
c
c  initiate fires on map
          call beginfiresim
          call writedata 
          if (waveans .eq. 'Y') then
c
c  make original ignition points orange
             do  i=1, istarts
               mapfire(mstart(i,1),mstart(i,2)) = 8
             enddo
c
             k=0
             do i=1,irow
                do j=1,jcol
             if (mapfire(i,j) .lt. 0) then
                idispvec(k) = mapfire(i,j)
             else if (mapfire(i,j) .eq. 0) then
                idispvec(k) = maphab(i,j)
             else if (mapfire(i,j) .gt. 0 .and. mapfire(i,j) .ne.8) then
                idispvec(k) = mapfire(i,j) + ihab + 1
             else
                idispvec(k) = 8
             endif
                   k=k+1
                enddo
             enddo
c  get the right pixmap to display in
             if (irep .eq. 1) then
                ipixid = -1
             else
                ipixid = ipixids(2)
             endif
          ierr=drawpixmap(ipixid,jcol,irow,idtype,idispvec,
     & idumm,mapcolor,firetitle)
             ipixids(2)=ipixid
             if (ierr .lt. 0) call pixmaperror(ierr)
          endif		! waveans = y
c
c
c  begin movements
          call movfire
c
c  simulation over -- accumulate statistics
          call accumstats
c
c
          if (mc .ne. 1 .and. riskans .eq. 'Y') then
c  add this result to risk probability map
             print*,'adding result to risk map'
             do j=1,jcol
                do i=1,irow
                   if (mapfire(i,j) .ne. 0) mapprob(i,j)=mapprob(i,j)+1
                enddo
             enddo
          endif         ! riskans = y and not monte carlo
c
c temporary
c          if (riskans .eq. 'Y') then
cc  display new risk probability map
cc
cc  make original ignition points white
c             print*,'displaying risk map'
c             do i=1, istarts
c                mapprob(mstart(i,1),mstart(i,2)) = -1
c             enddo
cc
c             k=0
c             do i=1,irow
c                do j=1,jcol
c                   if (mapprob(i,j).lt.0) then        ! this is ignition pt
c                      idispvec(k) = 101
c                   else if (mapprob(i,j).eq.0) then   ! this is unburned pt
c                      idispvec(k) = maphab(i,j)+101
c                   else                               ! this is burned pt
c                      idispvec(k) = (mapprob(i,j)*100)/nrep
c                      if (mc .eq. 1) idispvec(k) = (mapprob(i,j)*100)/25
c                   endif
c                   k=k+1
c                enddo
c             enddo
cc  get the right pixmap to display in
c             if (irep .eq. 1) then
c                ipixid = -1
c             else
c                ipixid = ipixids(3)
c             endif
c             ierr=drawpixmap(ipixid,jcol,irow,idtype,idispvec,
c     & idumm,probcolor,probtitle)
c             ipixids(3)=ipixid
c             if (ierr .lt. 0) call pixmaperror(ierr)
c
c          endif		! riskans = y
c
c
          close(13)	! close ignitions file
          close(30)	! close weather file
c
       enddo		! done with all replications
c
c**********************************************************************
c
       call statsout
       call landstat
       close(11)
       close(10)
       close(33)
c       close(32)
c
c  write out cumulative risk map
       if (riskans .eq. 'Y') then
c  use this to write rule risk map
          call rulerisk
          call xpmrisk
       endif
c
       if (mc .eq. 1) print*,'iadd is ',iadd
c
       if (waveans .eq. 'Y') then
c
c  make original ignition points orange
          do  i=1, istarts
            mapfire(mstart(i,1),mstart(i,2)) = 8
          enddo
c
          k=0
          do i=1,irow
             do j=1,jcol
                if (mapfire(i,j) .lt. 0) then
                   idispvec(k) = mapfire(i,j)
                else if (mapfire(i,j) .eq. 0) then
                   idispvec(k) = maphab(i,j)
                else if (mapfire(i,j).gt.0 .and. mapfire(i,j).ne.8) then
                   idispvec(k) = mapfire(i,j) + ihab + 1
                else
                   idispvec(k) = 8
                endif
                k=k+1
             enddo
          enddo
          ipixid=ipixids(2)
          ierr=drawpixmap(ipixid,jcol,irow,idtype,idispvec,
     & idumm,mapcolor,firetitle)
          ierr=drawpixmap(ipixid,jcol,irow,idtype,idispvec,
     & idumm,mapcolor,firetitle)
          if (ierr .lt. 0) call pixmaperror(ierr)
c
          write(*,96)
96        format (t10,'Pausing 120 seconds - 
     & Hit Ctrl-C to clear graphics windows')
          call sleep(120)
       endif
c
       return
       end
c======================================================================
