c  routines to generate hierarchical random maps
c **
       subroutine curdmap
       implicit none
       include 'parm.i'
c
       include 'common.i'
c
c       if (icasno .eq. 2) call curd2
       if (icasno .eq. 3) call curd3
c       if (icasno .eq. 4) call curd4
c       if (icasno .eq. 5) call curd5
c       if (icasno .eq. 6) call curd6
c
       return
       end
c
c **   
       subroutine curd3
       implicit none
       include 'parm.i'
c
       integer*2 blev1(225), blev2(225), blev3(225)
       integer*4 i, lev1, lev2, nx1, nx2, nx3, icnt, ii, jj
       integer*4 indx, jndx, jcnt, ki, kj
       real*4 pz
c
       include 'common.i'
c
c  maximum number of curds per level = 15
c
c  1st cascade
c      lev1 -- the number of rows of columns within each curd of
c              the first cascade
c      lev2 -- the number of rows or columns within the each curd of
c              the second level
c
c  stop execution if curds per level are greater than 15
       do i = 1,3
          if (ncas(i).gt.15) then
             write(*,100) i,ncas(i)
100          format (' Execution halted: curd level ',i2,' is ',
     &i3,'  only 15 levels currently allowed')
             stop
          endif
       enddo
c
       lev1 = irow / ncas(1)
       lev2 = lev1 / ncas(2)
       nx1 = ncas(1)*ncas(1)
       nx2 = ncas(2)*ncas(2)
       nx3 = ncas(3)*ncas(3)
c
c  select curds for 1st level
       call curdsel (nx1, pcas(1), blev1)
c
c  start the map generation
       icnt = 0
       do ii = 1,ncas(1)
          do jj = 1,ncas(1)
            indx = (ii-1) * lev1 + 2
            jndx = (jj-1) * lev1 + 2
            icnt = icnt + 1
c
c  if first level curd is on, then goto 2nd cascade
            if (blev1(icnt) .gt. 0) then 
                pz = pcas(2)
             else
                pz = qcas(2)
            endif
c
c  select curds for second level
            call curdsel (nx2, pz, blev2)
            jcnt = 0
            do ki = 1,ncas(2)
               do kj = 1,ncas(2)
                  jcnt = jcnt+1
c 
c  3rd cascade
                  if (blev2(jcnt) .gt. 0) then
                     call curdsel (nx3, pcas(3), blev3)
                   else
                     call curdsel (nx3, qcas(3), blev3)
                  endif              ! end of 3rd cascade loop
                  call lowcas (indx, jndx, ncas(3), blev3)
                  jndx = jndx + lev2
                enddo
                indx = indx + lev2
                jndx = (jj-1) * lev1 + 2
             enddo                    ! ki loop
c
         enddo                         ! jj loop
       enddo                           ! ii loop
c
       return
       end
c
c **
       subroutine curdsel (nx, pp, blev)
       implicit none
       include 'parm.i'
c
       integer*4 iseed, indx(225)
       integer*2 blev(225)
       real*4 ranx(225)
       integer*4 i, nx, ij, j, nooff, nrep, irep, iouts, imov, ivis
       real*4 xminimum, pp, p
       real*4 getrandom
       external getrandom
c
       common/blkprm/ iseed, nrep, irep, p, imov,
     & ivis, iouts
c
c   this routine generates a vector of boolean values by sampling
c      without replacement
c   generate vector of random numbers
       do i = 1,nx
          ranx(i) = getrandom()
          blev(i) = 1
       enddo
c
c   sort the random numbers
       do i = 1, nx
           xminimum = 1.1
          ij = 1
          do j = 1,nx
             if (ranx(j).lt. xminimum) then
                 ij = j
                  xminimum = ranx(j)
             endif
          enddo
          ranx(ij) = 2.0
          indx(i) = ij
       enddo
c
c   set blev = -1 if that curd if off
       nooff = int((1.0 - pp) * nx + 0.5)
       do i = 1, nooff
          blev(indx(i)) = -1
       enddo
c
       return
       end
c
c **
       subroutine lowcas (istart,jstart,isize,blev)
       implicit none
       include 'parm.i'
c
       integer*4 iseed
       integer*2 mapfire, maphab, mapprob, mapelev, idispvec
       integer*4 irep, imov, ivis, iouts, icnt
       integer*2 blev(225)
       integer*4 i, ii, istart, j, jj, jstart, isize, nrep
       real*4 p
c
       common/blkmap/ mapfire(maxprr,maxprc), maphab(maxprr,maxprc),
     & mapprob(maxprr,maxprc), mapelev(maxprr,maxprc), 
     & idispvec(0:maxprr*maxprc)
       common/blkprm/ iseed, nrep, irep, p, imov,
     & ivis, iouts
c
       icnt = 0
       do i = 1,isize
          ii = i+istart-1
          do j = 1,isize
             icnt = icnt+1
             jj = j+jstart-1
             if (blev(icnt) .gt. 0) maphab(ii,jj) = 1
          enddo
       enddo
c
       return
       end
