c
c  file unit numbers are as follows:
c   9	fire.scr execution script to repeat last run
c  10	radius.scratch
c  11	cfd.scratch
c  13	fire starts through time
c  14	used to read input map and elev map initially
c  100-150   output maps (limit 50)
c  17   used for firemat and spreadmat during input.f
c  40	cumulative risk map
c  30   weather course file
c  31	spread.matrix
c  32	exponential distances file
c  33	final burn map burn.out
c  34	wind.matrix
c  35	probability intermediates
c  36	stack intermediates
c
c  ispeed	synoptic wind speed class
c  nspeed	next synoptic wind speed class
c  istarts	number of initial fire starts
c  dir		compass wind direction
c  idir		numerical index for wind direction
c  ndir		next numerical index for wind direction
c  iclimate	type of climate
c  nclimate	next type of climate
c  startype	type of fire starts
c  firefile	name of fire probability matrix file
c  firemat	array containing fire probability matrix
c  windfile	name of wind speed bias probability file
c  windmat	array containing wind speed bias probability matrix
c  spreadfile	name of spread rate file
c  heatfile	name of heat content by fuel type file
c  spreadmat	array containing spread rate matrix
c  lastsprd	rate for penultimate weather condx
c  burntime	time to burn this cell
c  kclock	array containing spread rates for burning pixels
c  lastclk	array containing penultimate kclock for burning pixels
c  maxstarts	max size of mstart array with locations of fire starts
c  ipixids	array containing pixmap ids for windows in order called
c
c  elevans	will an elevation file be used?
c  elevfile	name of file with elevation map
c  mapelev	array containing elevation data for map
c
c  intout	response to save intermediate maps in files?
c  outfmtans    response for output file format type
c  habout	response to save initial habitat map in file?
c  outfreq	isave interval for saving wave outputs to files
c  chkwave	time-steps per wave output
c
c  sumr		sum of radii of burning pixels
c  sumrsqd	sum of squared radii of burning pixels
c  bsumr		sum of radii of burned pixels
c  bsumrsqd	sum of squared radii of burned pixels
c
c  edgenbr	edge reached by neighborhood spread flag
c  edgefb	edge reached by neighborhood spread flag
c  maxfiresend	max number of fires burning flag
c  maxburnedend	max number of cells burned flag
c  iseos	end-of-season flag
c  mc		monte carlo a single season flag
c
c  iseed is random number seed
c  otcnt = total number of populations that are extinct
c  dir	compass wind direction
c  ifcnt = total number of fires during simulation time step 
c
c  sevmax	maximum burn severity with input parameters
c  sevmin	minimum burn severity with input parameters
c
c  srthresh	threshold for stand-replacing burn severity
c
       integer*4 iseed, nrep, irep, imov, idtype, idumm, ierr
       integer*4 maxrow, maxcol, irow, jcol, ipixid, mstart
       integer*2 mapfire, maphab, mapprob, mapelev, idispvec
       integer*4 iburning, jburning, kclock, ipixids
       integer*4 ifirst, iadd
       integer*4 simlen, maxmov, maxfires, outfreq, maxburned
       integer*4 icasno, ncas
       integer*4 iws, i10hr, i1000hr
       integer*4 nws, n10hr, n1000hr
       integer*4 nxtwxyr, nxtwxmo, nxtwxdy, nxtwxhr, nxtwxmin, nxtwxsec
       integer*4 nxtstyr, nxtstmo, nxtstdy, nxtsthr, nxtstmin, nxtstsec
       integer*4 lststyr, lststmo, lststdy, lststhr, lststmin, lststsec
       integer*4 ifbno, ifile, ivis, iouts
       integer*4 ifcnt, iburned, ifage, itsteps
       integer*4 ispeed, idir, iclimate, istarts, inextclk
       integer*4 inextwx, inextign
       integer*4 nspeed, ndir, nclimate
       integer*4 spreadmat, lastsprd, lastclk, burntime, heat
       integer*4 ddim, timedate, istime, maxradbn, maxradbd
       integer*2 edgenbr, edgefb, maxfiresend, maxburnedend
       integer*2 iseos, mc
       integer*4 ifreq, ihfreq, ivfreq, ihedges, ivedges, ipijk
       integer*4 srthresh
       character*1 ans, outans, fbans, waveans, intout, fmtans, habout
       character*1 maptype, startype, stoptype, bchoice, outfmtans
       character*1 riskans, elevans, wxtype, ignans
       character*2 dir, wd, nwd
       character*9 mapcolor
       character*9 probcolor
       character*9 windcolor
       character*24 habtitle, firetitle, probtitle
       character*26 asptitle
       character*25 slopetitle
       character*5 windtitle
       character*60 mapfile, outfile, firefile, windfile, spreadfile
       character*60 firebrandfile, ignitionfile, ifbnofile, fbmeanfile
       character*60 elevfile, wxfile, slopefil, ignfile, heatfile
       real*4 p, scale, firemat, windmat, pcas, qcas, ignition, xfbmean
       character*12 lbl
       real*4 chkwave
       real*4 freq, slast, bfreq, slopefct, slopemax, slopeb
       real*4 xsum, xsscp, xmin, xmax, t
       real*4 sumr, sumrsqd, bsumr, bsumrsqd
       real*4 sevmax, sevmin
       real*4 aprob, hprob, vprob
c
       common/blkprm/ iseed, nrep, irep, p, idtype, idumm, ipixid
c  iseed     random number seed
c  nrep      number of replicate simulations
c  irep      the current replication number
c  p         the site-specific probability of site suitability
       common/blksiz/ maxrow, maxcol, irow, jcol, iclimate, istarts,
     & ivis, iouts, inextclk, istime, nws, n10hr, n1000hr
       common/blktim/ lststyr, lststmo, lststdy, lststhr, 
     & lststmin, lststsec
c  maxrow    the maximum number of rows and columns
c  irow      the number of rows and columns of current map
c  iclimate  type of climate

       common/blkmap/ mapfire(maxprr,maxprc), maphab(maxprr,maxprc), 
     & mapprob(maxprr,maxprc), mapelev(maxprr,maxprc),
     & idispvec(0:maxprr*maxprc)
c  mapfire   the fire map
c  maphab    the habitat map
c  mapprob   the risk map
c  mapelev   the elevation map
       common/blkvec/ iburning(maxprr*maxprc), jburning(maxprr*maxprc),
     & kclock(maxprr*maxprc), mstart(maxstarts,2), ipixids(10),
     & lastsprd(maxprr*maxprc), lastclk(maxprr*maxprc), 
     & burntime(maxprr*maxprc), ifirst(2), imov(2), iadd
c  iburning      vector of burning cell row locations
c  jburning      vector of burning cell column locations
	integer*4 irnd, jrnd, ihab, ihomohab, icdf, icnum, sumin, sumout
	real*4 dfreq
       common/blkmvr/ irnd(maxprr*maxprc), jrnd(maxprr*maxprc)
c  irnd      vector of relative row movements
c  jrnd      vector of relative column movements
       common/blkcnt/ ifbno(maxsp), ifcnt, idir,
     & ispeed, iburned, ifage, ifile, ndir, nclimate, nspeed, 
     & spreadmat(3,maxsp,0:2), heat(maxsp)
c  ifbno     number of firebrands from fires on this habitat
       common/blksim/ simlen, ddim, dfreq, maxmov, maxfires,
     & outfreq, maxburned, itsteps
c  simlen    length of simulation (total number of movements)
c  maxmov    maximum permissable movements
c  maxfires  maximum permissable fires
       common/blkflg/ edgenbr, edgefb, maxfiresend, maxburnedend,
     &  iseos, mc
       common/blkch1/ maptype, startype, stoptype, outans, bchoice,
     & fbans, waveans, intout, fmtans, habout, outfmtans, riskans,
     & elevans, wxtype, ignans
c  maptype   type of map to be generated
c  startype  type of fire starts
c  stoptype  rule for stopping simulation
c  outans       will output map be generated (y,n)
c  fbans       will firebrands be enabled? (y,n)
c  bchoice   method of initialization of map with fire starts
       common/blknam/ mapfile, outfile, firefile, windfile,
     & firebrandfile, spreadfile, elevfile, wxfile, slopefil,
     & ignfile, heatfile, mapcolor
c  mapfile   input map name
c  outfile   output map name
c  firefile  name of fire probability matrix file
c  spreadfile  name of fire spread matrix file
c  windfile  name of wind speed bias probability file
       common/blktit/ habtitle
       common/blkti2/ firetitle
       common/blkti3/ probtitle
       common/blkti5/ slopetitle
       common/blkti6/ windtitle
       common/blkti4/ asptitle
       common/blkti7/ probcolor
       common/blkcrd/ icasno, ncas(6), pcas(6), qcas(6)
       common/blkpop/ ihab, ihomohab, scale, firemat(3,maxsp,maxsp),
     & windmat(0:2,16), ignition(3,maxsp), xfbmean(0:maxsp)
c  ihab      number of habitats
c  ihomohab  number of homogeneous habitat for a uniform map
c  scale     linear dimension of a site
c  firemat   array containing fire probability matrix
c  idir      numerical index for wind direction
c  ispeed    synoptic wind speed class
c  windmat   array containing wind speed bias probability matrix
c       common/blkdis/ xmin, xmean, xmax
c  xmin      minimum distance moved by firebrands
c  xmean     mean distance moved by firebrands
c  xmax      maximum distance moved by firebrands
       common/blkcdf/ icdf(0:20)
c  icdf      cumulative frequency distribution array
       common/blkst / xsum(26), xsscp(26), xmin(26), xmax(26), lbl(26),
     & sumr, sumrsqd, bsumr, bsumrsqd, slopefct, slopemax,
     & maxradbn, maxradbd, sevmax, sevmin, chkwave
       common/blkmst/ icnum, freq, sumin, sumout, t(6)
       common/blkwx / wd, nwd
       common/blkint / inextwx, inextign
       common/blkldi / ifreq(0:maxsp+3), ihfreq(0:maxsp+3,0:maxsp+3),
     & ivfreq(0:maxsp+3,0:maxsp+3), ihedges(0:maxsp+3),
     & ivedges(0:maxsp+3), ipijk(0:maxsp+3,0:maxsp+3,0:maxsp+3),
     & srthresh
       common/blkldr / aprob(0:maxsp+3), hprob(0:maxsp+3,0:maxsp+3),
     & vprob(0:maxsp+3,0:maxsp+3)
