static char rcsid[] = "$Id$";
/*
 * $Log$
 *
 */

#include <stdio.h>
#include <strings.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/extensions/shape.h>
#include <X11/xpm.h>
#include "DrawPixmap.h"

#ifdef FUNCPROTO
extern char *malloc(unsigned int size);
#else /* FUNCPROTO */
extern char *malloc();
#endif /* FUNCPROTO */

#define XPMMAXDATA	1810	/* Maximum number of lines
				   (= ysize + num_colors + 1) */
#define MAXPIXMAPS	7	/* Maximum number of simultaneous pixmaps */
#define MAXCOLORS	256	/* Maximum number of colors (256 for 8 plane) */
#define SYMBOLLEN	3	/* Length of symbol */

static int first_time = 1;

static int Argc;
static char **Argv;

typedef struct _XpmIcon {
	Pixmap pixmap;
	Pixmap mask;
	XpmAttributes attributes;
} XpmIcon;

static struct {
	Widget widget;
	char killed;
	XpmIcon view;
	Colormap colormap;
	int xsize;
	int ysize;
	int dtype;
	char *cmapfile;
	char *colortable[MAXCOLORS][6];
	int ncolors;
	char *xpmdata[XPMMAXDATA];
} DrawPixmaps[MAXPIXMAPS];

static int DrawPixmapCount = 0;

static XrmOptionDescRec options[] = {
	{"-hints", ".hints", XrmoptionNoArg, (XtPointer) "True"},
};

#ifdef FUNCPROTO
main(int argc, char **argv)
#else /* FUNCPROTO */
main_(argc, argv)
int argc;
char **argv;
#endif /* FUNCPROTO */
{
	Argc = argc;
	Argv = argv;

#ifdef Debug
	fprintf(stderr, "main: about to call fire() to begin\n");
#endif /* Debug */

#ifdef G77
	fire_();
#else
	fire();
#endif

	exit(0);
}

#ifdef FUNCPROTO
char *mkstr(int size)
#else /* FUNCPROTO */
char *mkstr(size)
int size;
#endif /* FUNCPROTO */
{
	char *p;

	p = malloc((unsigned)size+1);

	return p;
}

#ifdef FUNCPROTO
int read_ct(char *cmapfile, char *colortable[MAXCOLORS][6])
#else /* FUNCPROTO */
int read_ct(cmapfile, colortable)
char *cmapfile, *colortable[MAXCOLORS][6];
#endif /* FUNCPROTO */
{
	FILE *cmap;
	char line[100], *p;
	int i, j;

#ifdef Debug
	fprintf(stderr, "read_ct: Opening cmap file %s\n", cmapfile);
#endif /* Debug */

	if ((cmap = fopen(cmapfile, "r")) == NULL) {
		fprintf(stderr, "Unable to open %s\n", cmapfile);
		exit(2);
	}

#ifdef Debug
	fprintf(stderr, "read_ct: Reading in cmap data\n");
#endif /* Debug */

	p = line;
	for (i = 0; p != NULL; ++i) {
		for (j = 0; j < 6 && p != NULL; ++j) {
			p = fgets(line, 100, cmap);
			if (p != NULL) {
				line[(strlen(line)-1)] = '\0';
#ifdef Debug1
				fprintf(stderr, "read_ct: Got line %s\n", line);
#endif /* Debug1 */
				if ((colortable[i][j] = 
				     (char*) malloc( (strlen(line) + 1) * 
						     sizeof(char) ) ) == NULL){
#ifdef Debug
					fprintf(stderr, "read_ct: Out of \
memory\n");
#endif /* Debug */
					return OUT_OF_MEMORY;
				}
				strcpy(colortable[i][j], line);
#ifdef Debug1
				fprintf(stderr, "read_ct: stored line is %s\n",
					colortable[i][j]);
#endif /* Debug1 */
			}
		}
	}
#ifdef Debug
	fprintf(stderr, "read_ct: Closing cmap file\n");
#endif /* Debug */

	fclose(cmap);

#ifdef Debug
	fprintf(stderr, "read_ct: number of colors = %ld\n", i);
	fprintf(stderr, "read_ct: Returning %ld\n", (i-1));
#endif /* Debug */

	return (i-1);
}

#ifdef FUNCPROTO
int KillPixmap(int *pixid)
#else /* FUNCPROTO */
int KillPixmap(pixid)
int *pixid;
#endif /* FUNCPROTO */
{
	int i, j;

#ifdef Debug
	fprintf(stderr, "KillPixmap: called with pixid %ld\n", *pixid);
#endif /* Debug */

	if (*pixid >= DrawPixmapCount || *pixid < 0) {
#ifdef Debug
		fprintf(stderr, "KillPixmap: pixid %ld does not exist.\n",
			*pixid);
#endif /* Debug */
		return BAD_PIXID;
	}

	XtUnrealizeWidget(DrawPixmaps[*pixid].widget);
#ifdef Debug
	fprintf(stderr, "KillPixmap: successful call to XtUnrealizeWidget()\n");
#endif /* Debug */

#ifdef Debug
	fprintf(stderr, "KillPixmap: freeing up resources\n");
#endif /* Debug */
	XFreePixmap(XtDisplay(DrawPixmaps[*pixid].widget),
		DrawPixmaps[*pixid].view.pixmap);
	if (DrawPixmaps[*pixid].view.mask)
		XFreePixmap(XtDisplay(DrawPixmaps[*pixid].widget),
			DrawPixmaps[*pixid].view.mask);
	XFreeColors(XtDisplay(DrawPixmaps[*pixid].widget),
		DrawPixmaps[*pixid].colormap,
		DrawPixmaps[*pixid].view.attributes.pixels,
		DrawPixmaps[*pixid].view.attributes.npixels, 0);
	XpmFreeAttributes(&DrawPixmaps[*pixid].view.attributes);

	for (i = 0; i < (DrawPixmaps[*pixid].ysize +
		DrawPixmaps[*pixid].ncolors + 1); ++i)
		free(DrawPixmaps[*pixid].xpmdata[i]);

	free(DrawPixmaps[*pixid].cmapfile);

	for (i = 0; i < DrawPixmaps[*pixid].ncolors; ++i) {
		for (j = 0; j < 6; ++j) {
			free(DrawPixmaps[*pixid].colortable[i][j]);
		}
	}

	XtUnmapWidget(DrawPixmaps[*pixid].widget);
	XtDestroyWidget(DrawPixmaps[*pixid].widget);

	{
		XEvent event;
		for (;XtPending();) {
			XtNextEvent(&event);
			XtDispatchEvent(&event);
		}
	}

	return XtPending();
}

#ifdef FUNCPROTO
int drawpixmap(int *pixid, int *xsize, int *ysize, int *dtype, short int *data,
	int *mask, char *cmapfile, char *pixtitle)
#else /* FUNCPROTO */
int drawpixmap(pixid, xsize, ysize, dtype, data, mask, cmapfile, pixtitle)
int *pixid, *xsize, *ysize, *dtype, *mask;
short int *data;
char *cmapfile, *pixtitle;
#endif /* FUNCPROTO */
{
	char *stype;
	char fmtstring[10];
	unsigned int w_rtn, h_rtn;
	int n = 0, resize = 0, incResize = 0, xhotspot = 0, yhotspot = 0;
	int ErrorStatus;
	Arg args[4];
	XrmValue val;
	XSizeHints size_hints;
	char *p;
	int i, j, l, new = 0;
	char *bp;	/* byte pointer */
	short int *sp;	/* short pointer */
	long int *lp;	/* long pointer */

#ifdef Debug
	fprintf(stderr, "DrawPixmap: DrawPixmap called with pixid %ld\n",
		*pixid);
#endif /* Debug */

	/* Check pixid to see if it already exists.  Pixid should = -1
	   for a new pixmap. */
	if (*pixid < 0) {
		/* new pixmap */
#ifdef Debug
			fprintf(stderr, "DrawPixmap: NEW PIXMAP!\n");
#endif /* Debug */
		if (DrawPixmapCount == MAXPIXMAPS) {
#ifdef Debug
			fprintf(stderr, "DrawPixmap: Maximum number of \
simultaneous pixmaps (%ld) exceeded\n", MAXPIXMAPS);
			fprintf(stderr, "DrawPixmap: Recompile with a larger \
number for MAXPIXMAPS\n");
#endif /* Debug */
			return MAX_PIXMAPS_EXCEEDED;
		}
		*pixid = DrawPixmapCount;
		++DrawPixmapCount;
#ifdef Debug
		fprintf(stderr, "DrawPixmap: Creating new pixmap with pixid \
%ld\n", *pixid);
#endif /* Debug */
		if ((DrawPixmaps[*pixid].cmapfile = 
		     (char*) malloc(10 * sizeof(char) ) ) == NULL ) {
#ifdef Debug
			fprintf(stderr, "DrawPixmap: Out of memory\n");
#endif /* Debug */
			return OUT_OF_MEMORY;
		}
		strncpy(DrawPixmaps[*pixid].cmapfile, cmapfile, 9);
		DrawPixmaps[*pixid].cmapfile[9] = '\0';
		DrawPixmaps[*pixid].ncolors = 0;
		new = 1;
	}
	else {
		/* old pixmap */
#ifdef Debug
			fprintf(stderr, "DrawPixmap: OLD PIXMAP!\n");
#endif /* Debug */
		if (*pixid >= DrawPixmapCount) {
#ifdef Debug
			fprintf(stderr, "DrawPixmap: pixid %ld does not \
exist.\n", *pixid);
#endif /* Debug */
			return BAD_PIXID;
		}
		new = 0;
		XFreePixmap(XtDisplay(DrawPixmaps[*pixid].widget),
			DrawPixmaps[*pixid].view.pixmap);
		if (DrawPixmaps[*pixid].view.mask)
			XFreePixmap(XtDisplay(DrawPixmaps[*pixid].widget),
				DrawPixmaps[*pixid].view.mask);
		XFreeColors(XtDisplay(DrawPixmaps[*pixid].widget),
			DrawPixmaps[*pixid].colormap,
			DrawPixmaps[*pixid].view.attributes.pixels,
			DrawPixmaps[*pixid].view.attributes.npixels, 0);
		XpmFreeAttributes(&DrawPixmaps[*pixid].view.attributes);

		for (i = 0; i < (DrawPixmaps[*pixid].ysize +
			DrawPixmaps[*pixid].ncolors + 1); ++i)
			free(DrawPixmaps[*pixid].xpmdata[i]);
	}
	DrawPixmaps[*pixid].xsize = *xsize;
	DrawPixmaps[*pixid].ysize = *ysize;
	DrawPixmaps[*pixid].dtype = *dtype;

	if (!DrawPixmaps[*pixid].ncolors ||
		strcmp(DrawPixmaps[*pixid].cmapfile, cmapfile) != 0) {
		free(DrawPixmaps[*pixid].cmapfile);
		if ((DrawPixmaps[*pixid].cmapfile = (char*) 
		     malloc(10 * sizeof(char) ) ) == NULL) {
#ifdef Debug
			fprintf(stderr, "DrawPixmap: Out of memory\n");
#endif /* Debug */
			return OUT_OF_MEMORY;
		}
		strncpy(DrawPixmaps[*pixid].cmapfile, cmapfile, 9);
		DrawPixmaps[*pixid].cmapfile[9] = '\0';
		
#ifdef Debug
		fprintf(stderr, "Freeing up color table\n");
#endif /* Debug */
		for (i = 0; i < DrawPixmaps[*pixid].ncolors; ++i) {
			for (j = 0; j < 6; ++j) {
				free(DrawPixmaps[*pixid].colortable[i][j]);
			}
		}
#ifdef Debug
		fprintf(stderr, "DrawPixmap: About to call read_ct() to load \
the color table\n");
#endif /* Debug */
		DrawPixmaps[*pixid].ncolors =
			read_ct(DrawPixmaps[*pixid].cmapfile,
			DrawPixmaps[*pixid].colortable);
	}
#ifdef Debug
	fprintf(stderr, "DrawPixmap: colortable contains %ld colors\n",
		DrawPixmaps[*pixid].ncolors);
#endif /* Debug */

	/* Convert raw data into Xpm data */
	if ((p = mkstr(100)) == NULL) {
#ifdef Debug
		fprintf(stderr, "DrawPixmap: Out of memory\n");
#endif /* Debug */
		return OUT_OF_MEMORY;
	}

#ifdef Debug1
	fprintf(stderr, "DrawPixmap: Creating first line of xpmdata\n");
#endif /* Debug1 */
	sprintf(p, "%ld %ld %ld %ld %ld %ld", DrawPixmaps[*pixid].xsize,
		DrawPixmaps[*pixid].ysize, DrawPixmaps[*pixid].ncolors,
		SYMBOLLEN, xhotspot, yhotspot);
#ifdef Debug1
	fprintf(stderr, "DrawPixmap: First line reads: %s\n", p);
	fprintf(stderr, "DrawPixmap: Saving this to xmpdata[0]\n");
#endif /* Debug1 */
	DrawPixmaps[*pixid].xpmdata[0] = p;
#ifdef Debug1
	fprintf(stderr, "DrawPixmap: Now xmpdata[0] reads: %s\n",
		DrawPixmaps[*pixid].xpmdata[0]);
#endif /* Debug1 */
	/* Put in color information */
	for (l = 1; l < DrawPixmaps[*pixid].ncolors+1; ++l) {
		if ((p = mkstr(100)) == NULL) {
#ifdef Debug
			fprintf(stderr, "DrawPixmap: Out of memory\n");
#endif /* Debug */
			return OUT_OF_MEMORY;
		}
		sprintf(p, "%s s %s m %s g4 %s g %s c %s ",
			DrawPixmaps[*pixid].colortable[l-1][0],
			DrawPixmaps[*pixid].colortable[l-1][1],
			DrawPixmaps[*pixid].colortable[l-1][2],
			DrawPixmaps[*pixid].colortable[l-1][3],
			DrawPixmaps[*pixid].colortable[l-1][4],
			DrawPixmaps[*pixid].colortable[l-1][5]);
		DrawPixmaps[*pixid].xpmdata[l] = p;
	}

	switch (DrawPixmaps[*pixid].dtype) {
		case sizeof(char):
#ifdef Debug
			fprintf(stderr, "DrawPixmap: Data type is byte\n");
#endif /* Debug */
			bp = (char *)data;
			sprintf(fmtstring, "%%%ldd", SYMBOLLEN);
			for (j = 0; j < *ysize; ++j) {
				if ((p = mkstr((*xsize*SYMBOLLEN)+1)) == NULL) {
#ifdef Debug
					fprintf(stderr, "DrawPixmap: Out of \
memory\n");
#endif /* Debug */
					return OUT_OF_MEMORY;
				}
				for (i = 0; i < *xsize; ++i) {
					sprintf(&p[i*SYMBOLLEN], fmtstring,
						*(bp+(j* *xsize)+i));
				}
				DrawPixmaps[*pixid].xpmdata[j+l] = p;
			}
			break;
		case sizeof(short int):
#ifdef Debug
			fprintf(stderr, "DrawPixmap: Data type is short int\n");
#endif /* Debug */
			sp = (short int *)data;
			sprintf(fmtstring, "%%%ldd", SYMBOLLEN);
			for (j = 0; j < *ysize; ++j) {
				if ((p = mkstr((*xsize*SYMBOLLEN)+1)) == NULL) {
#ifdef Debug
					fprintf(stderr, "DrawPixmap: Out of \
memory\n");
#endif /* Debug */
					return OUT_OF_MEMORY;
				}
				for (i = 0; i < *xsize; ++i) {
					sprintf(&p[i*SYMBOLLEN], fmtstring,
						*(sp+(j* *xsize)+i));
				}
				DrawPixmaps[*pixid].xpmdata[j+l] = p;
			}
			break;
		case sizeof(long int):
#ifdef Debug
#endif /* Debug */
			lp = (long int *)data;
			sprintf(fmtstring, "%%%ldld", SYMBOLLEN);
			for (j = 0; j < *ysize; ++j) {
				if ((p = mkstr((*xsize*SYMBOLLEN)+1)) == NULL) {
#ifdef Debug
					fprintf(stderr, "DrawPixmap: Out of \
memory\n");
#endif /* Debug */
					return OUT_OF_MEMORY;
				}
				for (i = 0; i < *xsize; ++i) {
					sprintf(&p[i*SYMBOLLEN], fmtstring,
						*(lp+(j* *xsize)+i));
				}
				DrawPixmaps[*pixid].xpmdata[j+l] = p;
			}
			break;
		default:
			fprintf(stderr, "Data type is unknown\n");
			exit(2);
			break;
	}
#ifdef Debug1
	for (i = 0; i < 120; ++i) {
		fprintf(stderr, "DrawPixmap: xpmdata[%ld] is %s\n", i,
			DrawPixmaps[*pixid].xpmdata[i]);
	}
#endif /* Debug1 */

#ifdef Debug
	fprintf(stderr, "DrawPixmap: checking command line arguments: ");
	for (i = 0; i < Argc; ++i)
		fprintf(stderr, "%s ", Argv[i]);
	fprintf(stderr, "\n");
#endif /* Debug */
		
if (new) {
	DrawPixmaps[*pixid].widget = XtInitialize("DrawPixmap", "DrawPixmap",
		options, XtNumber(options), &Argc, Argv);

	if (!DrawPixmaps[*pixid].widget) {
		fprintf(stderr, "Undefined DISPLAY\n");
		exit(1);
	}
#ifdef Debug
	fprintf(stderr, "DrawPixmap: Successful call to XtInitialize\n");
#endif /* Debug */
}

	DrawPixmaps[*pixid].colormap = XDefaultColormapOfScreen(
		XtScreen(DrawPixmaps[*pixid].widget));

	if (XrmGetResource(XtDatabase(XtDisplay(DrawPixmaps[*pixid].widget)),
		NULL, "DrawPixmap.geometry", &stype, &val)
		|| XrmGetResource(XtDatabase(XtDisplay(
		DrawPixmaps[*pixid].widget)), NULL, "DrawPixmap.geometry",
		&stype, &val)){
		int flags;
		int x_rtn;
		int y_rtn;
		char *geo = NULL;

		geo = (char *)val.addr;
		flags = XParseGeometry(geo, &x_rtn, &y_rtn,
			(unsigned int *)&w_rtn, (unsigned int *)&h_rtn);
		if (!((WidthValue & flags) && (HeightValue & flags)))
			resize = 1;
	}
	else
		resize = 1;

#ifdef Debug
	fprintf(stderr, "DrawPixmap: Done with getting geometry info from \
Xrm\n");
#endif /* Debug */

if (new) {
	if (resize) {
		w_rtn = 0;
		h_rtn = 0;
		XtSetArg(args[n], XtNwidth, 1);
		++n;
		XtSetArg(args[n], XtNheight, 1);
		++n;
	}
	XtSetArg(args[n], XtNmappedWhenManaged, False);
	++n;
	if (pixtitle != NULL) {
		XtSetArg(args[n], XtNtitle, pixtitle);
		++n;
	}
}
else {
	resize = 1;
}

#ifdef Debug
	fprintf(stderr, "DrawPixmap: Done with XtSetArg calls, n = %ld\n", n);
#endif /* Debug */
	XtSetValues(DrawPixmaps[*pixid].widget, args, n);
#ifdef Debug
	fprintf(stderr, "DrawPixmap: Done with XtSetValues call\n");
#endif /* Debug */

if (first_time) {
	if ((XrmGetResource(XtDatabase(XtDisplay(DrawPixmaps[*pixid].widget)),
		"DrawPixmap.hints", "", &stype, &val) ||
		XrmGetResource(XtDatabase(XtDisplay(
		DrawPixmaps[*pixid].widget)), "DrawPixmap.hints", "", &stype,
		&val)) && !strcmp((char *)val.addr, "True")) {
		incResize = 1;
		resize = 1;
	}
	first_time = 0;
}

if (new) {
	XtRealizeWidget(DrawPixmaps[*pixid].widget);
#ifdef Debug
	fprintf(stderr, "DrawPixmap: Successful call to XtRealizeWidget\n");
#endif /* Debug */
}

	/* private colormap */
/*	if (privatecmap) {
		DrawPixmaps[*pixid].colormap = XCreateColormap(XtDisplay(
			DrawPixmaps[*pixid].widget), XtWindow(
			DrawPixmaps[*pixid].widget), DefaultVisual(XtDisplay(
			DrawPixmaps[*pixid].widget), DefaultScreen(XtDisplay(
			DrawPixmaps[*pixid].widget))), AllocNone);
		DrawPixmaps[*pixid].view.attributes.colormap =
			DrawPixmaps[*pixid].colormap;
		XSetWindowColormap(XtDisplay(DrawPixmaps[*pixid].widget),
			XtWindow(DrawPixmaps[*pixid].widget),
			DrawPixmaps[*pixid].colormap);
	}
*/
	DrawPixmaps[*pixid].view.attributes.colorsymbols =
		(XpmColorSymbol *)NULL;
	DrawPixmaps[*pixid].view.attributes.numsymbols = 0;
	DrawPixmaps[*pixid].view.attributes.valuemask = 0;
	DrawPixmaps[*pixid].view.attributes.colorTable =
		(XpmColor *)DrawPixmaps[*pixid].colortable;

/* start of block */
#ifdef Debug
	fprintf(stderr, "DrawPixmap: About to call \
XpmCreatePixmapFromData()\n");
#endif /* Debug */
	ErrorStatus = XpmCreatePixmapFromData(XtDisplay(
		DrawPixmaps[*pixid].widget), XtWindow(
		DrawPixmaps[*pixid].widget), DrawPixmaps[*pixid].xpmdata,
		&DrawPixmaps[*pixid].view.pixmap,
		&DrawPixmaps[*pixid].view.mask,
		&DrawPixmaps[*pixid].view.attributes);
#ifdef Debug
	fprintf(stderr, "DrawPixmap: ErrorStatus %ld returned from \
XpmCreatePixmapFromData()\n", ErrorStatus);
#endif /* Debug */

	if (ErrorStatus)
		return XPM_ERROR;

/* end of block */

	if (w_rtn && h_rtn && ((w_rtn <
		DrawPixmaps[*pixid].view.attributes.width) || h_rtn <
		DrawPixmaps[*pixid].view.attributes.height))
		resize = 1;

	if (resize)
		XtResizeWidget(DrawPixmaps[*pixid].widget,
			DrawPixmaps[*pixid].view.attributes.width,
			DrawPixmaps[*pixid].view.attributes.height, 1);

	if (incResize) {
		size_hints.flags = USSize | PMinSize | PResizeInc;
		size_hints.height = DrawPixmaps[*pixid].view.attributes.height;
		size_hints.width = DrawPixmaps[*pixid].view.attributes.width;
		size_hints.height_inc =
			DrawPixmaps[*pixid].view.attributes.height;
		size_hints.width_inc =
			DrawPixmaps[*pixid].view.attributes.width;
	}
	else
		size_hints.flags = PMinSize;

	size_hints.min_height = DrawPixmaps[*pixid].view.attributes.height;
	size_hints.min_width = DrawPixmaps[*pixid].view.attributes.width;
	XSetWMNormalHints(XtDisplay(DrawPixmaps[*pixid].widget),
		XtWindow(DrawPixmaps[*pixid].widget), &size_hints);

	XSetWindowBackgroundPixmap(XtDisplay(DrawPixmaps[*pixid].widget),
		XtWindow(DrawPixmaps[*pixid].widget),
		DrawPixmaps[*pixid].view.pixmap);

	if (DrawPixmaps[*pixid].view.mask)
		XShapeCombineMask(XtDisplay(DrawPixmaps[*pixid].widget),
			XtWindow(DrawPixmaps[*pixid].widget), ShapeBounding,
			0, 0, DrawPixmaps[*pixid].view.mask, ShapeSet);

	XClearWindow(XtDisplay(DrawPixmaps[*pixid].widget),
		XtWindow(DrawPixmaps[*pixid].widget));
	XMapWindow(XtDisplay(DrawPixmaps[*pixid].widget),
		XtWindow(DrawPixmaps[*pixid].widget));

	{
		XEvent event;
		for (;XtPending();) {
			XtNextEvent(&event);
			XtDispatchEvent(&event);
		}
	}

	return XtPending();
}

#ifdef FUNCPROTO
int drawpixmap_(int *pixid, int *xsize, int *ysize, int *dtype, 
		short int *data,
		int *mask, char *cmapfile, char *pixtitle)
#else /* FUNCPROTO */
int drawpixmap_(pixid, xsize, ysize, dtype, data, mask, cmapfile, pixtitle)
int *pixid, *xsize, *ysize, *dtype, *mask;
short int *data;
char *cmapfile, *pixtitle;
#endif /* FUNCPROTO */
{
	return drawpixmap(pixid, xsize, ysize, dtype, data, mask, cmapfile,
		pixtitle);
}

#ifdef FUNCPROTO
MAIN(int argc, char **argv)
#else /* FUNCPROTO */
MAIN_(argc, argv)
int argc;
char **argv;
#endif /* FUNCPROTO */
{
	return main_(argc, argv);
}
